/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildParameters;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTEnvironment;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTOptions;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPostBuild;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTools;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTriggers;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTPipelineDef
extends ModelASTElement {
    private ModelASTStages stages;
    private ModelASTPostBuild postBuild;
    private ModelASTEnvironment environment;
    private ModelASTAgent agent;
    private ModelASTTools tools;
    private ModelASTOptions options;
    private ModelASTBuildParameters parameters;
    private ModelASTTriggers triggers;

    public ModelASTPipelineDef(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONObject a = new JSONObject();
        a.put("stages", this.stages != null ? this.stages.toJSON() : null);
        a.put("post", this.postBuild != null ? this.postBuild.toJSON() : null);
        a.put("environment", this.environment != null ? this.environment.toJSON() : null);
        a.put("agent", this.agent != null ? this.agent.toJSON() : null);
        a.put("tools", this.tools != null ? this.tools.toJSON() : null);
        if (this.options != null && !this.options.getOptions().isEmpty()) {
            a.put("options", (Object)this.options.toJSON());
        } else {
            a.put("options", null);
        }
        if (this.parameters != null && !this.parameters.getParameters().isEmpty()) {
            a.put("parameters", (Object)this.parameters.toJSON());
        } else {
            a.put("parameters", null);
        }
        if (this.triggers != null && !this.triggers.getTriggers().isEmpty()) {
            a.put("triggers", (Object)this.triggers.toJSON());
        } else {
            a.put("triggers", null);
        }
        return new JSONObject().accumulate("pipeline", (Object)a);
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        if (this.stages != null) {
            this.stages.validate(validator);
        }
        if (this.postBuild != null) {
            this.postBuild.validate(validator);
        }
        if (this.environment != null) {
            this.environment.validate(validator);
        }
        if (this.agent != null) {
            this.agent.validate(validator);
        }
        if (this.tools != null) {
            this.tools.validate(validator);
        }
        if (this.options != null) {
            this.options.validate(validator);
        }
        if (this.parameters != null) {
            this.parameters.validate(validator);
        }
        if (this.triggers != null) {
            this.triggers.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        result.append("pipeline {\n");
        if (this.agent != null) {
            result.append(this.agent.toGroovy());
        }
        if (this.stages != null) {
            result.append(this.stages.toGroovy());
        }
        if (this.tools != null) {
            result.append(this.tools.toGroovy());
        }
        if (this.environment != null) {
            result.append(this.environment.toGroovy());
        }
        if (this.postBuild != null) {
            result.append(this.postBuild.toGroovy());
        }
        if (this.options != null && !this.options.getOptions().isEmpty()) {
            result.append(this.options.toGroovy());
        }
        if (this.parameters != null && !this.parameters.getParameters().isEmpty()) {
            result.append(this.parameters.toGroovy());
        }
        if (this.triggers != null && !this.triggers.getTriggers().isEmpty()) {
            result.append(this.triggers.toGroovy());
        }
        result.append("}\n");
        return result.toString();
    }

    public String toPrettyGroovy() {
        StringBuilder result = new StringBuilder();
        int indentCount = 0;
        boolean tripleSingleQuotedString = false;
        boolean first = true;
        for (String r : this.toGroovy().split("\n")) {
            if (first) {
                first = false;
            } else {
                result.append('\n');
            }
            if (tripleSingleQuotedString) {
                result.append(r);
            } else {
                if (r.startsWith("}") || r.startsWith(")") || r.startsWith("]")) {
                    --indentCount;
                }
                result.append(this.indent(indentCount)).append(r);
                if (r.endsWith("{") || r.endsWith("(") || r.endsWith("[")) {
                    ++indentCount;
                }
            }
            int index = r.indexOf("'''");
            while (index != -1) {
                tripleSingleQuotedString = !tripleSingleQuotedString;
                index = r.indexOf("'''", index + 3);
            }
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        if (this.stages != null) {
            this.stages.removeSourceLocation();
        }
        if (this.postBuild != null) {
            this.postBuild.removeSourceLocation();
        }
        if (this.environment != null) {
            this.environment.removeSourceLocation();
        }
        if (this.tools != null) {
            this.tools.removeSourceLocation();
        }
        if (this.options != null) {
            this.options.removeSourceLocation();
        }
        if (this.parameters != null) {
            this.parameters.removeSourceLocation();
        }
        if (this.triggers != null) {
            this.triggers.removeSourceLocation();
        }
    }

    private String indent(int count) {
        return StringUtils.repeat((String)"  ", (int)count);
    }

    public ModelASTStages getStages() {
        return this.stages;
    }

    public void setStages(ModelASTStages stages) {
        this.stages = stages;
    }

    public ModelASTPostBuild getPostBuild() {
        return this.postBuild;
    }

    public void setPostBuild(ModelASTPostBuild postBuild) {
        this.postBuild = postBuild;
    }

    public ModelASTEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ModelASTEnvironment environment) {
        this.environment = environment;
    }

    public ModelASTAgent getAgent() {
        return this.agent;
    }

    public void setAgent(ModelASTAgent agent) {
        this.agent = agent;
    }

    public ModelASTTools getTools() {
        return this.tools;
    }

    public void setTools(ModelASTTools tools) {
        this.tools = tools;
    }

    public ModelASTOptions getOptions() {
        return this.options;
    }

    public void setOptions(ModelASTOptions options) {
        this.options = options;
    }

    public ModelASTBuildParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ModelASTBuildParameters parameters) {
        this.parameters = parameters;
    }

    public ModelASTTriggers getTriggers() {
        return this.triggers;
    }

    public void setTriggers(ModelASTTriggers triggers) {
        this.triggers = triggers;
    }

    @Override
    public String toString() {
        return "ModelASTPipelineDef{stages=" + this.stages + ", post=" + this.postBuild + ", environment=" + this.environment + ", agent=" + this.agent + ", tools=" + this.tools + ", options=" + this.options + ", parameters=" + this.parameters + ", triggers=" + this.triggers + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTPipelineDef that = (ModelASTPipelineDef)o;
        if (this.getStages() != null ? !this.getStages().equals(that.getStages()) : that.getStages() != null) {
            return false;
        }
        if (this.getPostBuild() != null ? !this.getPostBuild().equals(that.getPostBuild()) : that.getPostBuild() != null) {
            return false;
        }
        if (this.getEnvironment() != null ? !this.getEnvironment().equals(that.getEnvironment()) : that.getEnvironment() != null) {
            return false;
        }
        if (this.getAgent() != null ? !this.getAgent().equals(that.getAgent()) : that.getAgent() != null) {
            return false;
        }
        if (this.getTools() != null ? !this.getTools().equals(that.getTools()) : that.getTools() != null) {
            return false;
        }
        if (this.getOptions() != null ? !this.getOptions().equals(that.getOptions()) : that.getOptions() != null) {
            return false;
        }
        if (this.getParameters() != null ? !this.getParameters().equals(that.getParameters()) : that.getParameters() != null) {
            return false;
        }
        return this.getTriggers() != null ? this.getTriggers().equals(that.getTriggers()) : that.getTriggers() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getStages() != null ? this.getStages().hashCode() : 0);
        result = 31 * result + (this.getPostBuild() != null ? this.getPostBuild().hashCode() : 0);
        result = 31 * result + (this.getEnvironment() != null ? this.getEnvironment().hashCode() : 0);
        result = 31 * result + (this.getAgent() != null ? this.getAgent().hashCode() : 0);
        result = 31 * result + (this.getTools() != null ? this.getTools().hashCode() : 0);
        result = 31 * result + (this.getOptions() != null ? this.getOptions().hashCode() : 0);
        result = 31 * result + (this.getParameters() != null ? this.getParameters().hashCode() : 0);
        result = 31 * result + (this.getTriggers() != null ? this.getTriggers().hashCode() : 0);
        return result;
    }
}

