/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTOption;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTOptions
extends ModelASTElement {
    private List<ModelASTOption> options = new ArrayList<ModelASTOption>();
    private boolean inStage = false;

    public ModelASTOptions(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTOption option : this.options) {
            a.add((Object)option.toJSON());
        }
        return new JSONObject().accumulate("options", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTOption option : this.options) {
            option.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("options {\n");
        for (ModelASTOption option : this.options) {
            result.append(option.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTOption option : this.options) {
            option.removeSourceLocation();
        }
    }

    public List<ModelASTOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<ModelASTOption> options) {
        this.options = options;
    }

    public boolean isInStage() {
        return this.inStage;
    }

    public void setInStage(boolean inStage) {
        this.inStage = inStage;
    }

    @Override
    public String toString() {
        return "ModelASTOptions{options=" + this.options + ",inStage=" + this.inStage + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTOptions that = (ModelASTOptions)o;
        if (!this.isInStage() == that.isInStage()) {
            return false;
        }
        return this.getOptions() != null ? this.getOptions().equals(that.getOptions()) : that.getOptions() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getOptions() != null ? this.getOptions().hashCode() : 0);
        result = 31 * result + (this.isInStage() ? 1 : 0);
        return result;
    }
}

