/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTrigger;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTTriggers
extends ModelASTElement {
    private List<ModelASTTrigger> triggers = new ArrayList<ModelASTTrigger>();

    public ModelASTTriggers(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTTrigger trigger : this.triggers) {
            a.add((Object)trigger.toJSON());
        }
        return new JSONObject().accumulate("triggers", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTTrigger trigger : this.triggers) {
            trigger.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("triggers {\n");
        for (ModelASTTrigger trigger : this.triggers) {
            result.append(trigger.toGroovy()).append('\n');
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTTrigger trigger : this.triggers) {
            trigger.removeSourceLocation();
        }
    }

    public List<ModelASTTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<ModelASTTrigger> triggers) {
        this.triggers = triggers;
    }

    @Override
    public String toString() {
        return "ModelASTTriggers{triggers=" + this.triggers + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTTriggers that = (ModelASTTriggers)o;
        return this.getTriggers() != null ? this.getTriggers().equals(that.getTriggers()) : that.getTriggers() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getTriggers() != null ? this.getTriggers().hashCode() : 0);
        return result;
    }
}

