/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.Messages;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.cps.SnippetizerLink;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowMultiBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class DirectiveGenerator
extends Snippetizer {
    private static final Logger LOGGER = Logger.getLogger(DirectiveGenerator.class.getName());
    public static final String ACTION_URL = "directive-generator";
    @Restricted(value={NoExternalUse.class})
    public static final String GENERATE_URL = "directive-generator/generateDirective";

    public String getUrlName() {
        return ACTION_URL;
    }

    @NonNull
    public List<DirectiveDescriptor> getDirectives() {
        return DirectiveDescriptor.all();
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doGenerateDirective(StaplerRequest2 req, @QueryParameter String json) throws Exception {
        Describable o;
        Class<?> c;
        JSONObject jsonO = JSONObject.fromObject((Object)json);
        Jenkins j = Jenkins.get();
        DirectiveDescriptor descriptor = (DirectiveDescriptor)j.getDescriptor((c = j.getPluginManager().uberClassLoader.loadClass(jsonO.getString("stapler-class"))).asSubclass(AbstractDirective.class));
        if (descriptor == null) {
            return HttpResponses.plainText((String)("<could not find " + c.getName() + ">"));
        }
        try {
            o = descriptor.newInstance(req, jsonO);
        }
        catch (RuntimeException x) {
            return HttpResponses.plainText((String)Functions.printThrowable((Throwable)x));
        }
        try {
            String groovy = descriptor.toIndentedGroovy((AbstractDirective)o);
            return HttpResponses.plainText((String)groovy);
        }
        catch (UnsupportedOperationException x) {
            LOGGER.log(Level.WARNING, "failed to render " + json, x);
            return HttpResponses.plainText((String)x.getMessage());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static String mapToClosure(Map<String, ?> args) {
        StringBuilder result = new StringBuilder("{\n");
        for (Map.Entry<String, ?> arg : args.entrySet()) {
            if (arg.getValue() instanceof String && arg.getValue().equals("")) continue;
            result.append(arg.getKey()).append(" ");
            if (arg.getValue() instanceof Map) {
                result.append(DirectiveGenerator.mapToClosure((Map)arg.getValue()));
                continue;
            }
            if (arg.getValue() == null) continue;
            result.append(Snippetizer.object2Groovy(arg.getValue(), (boolean)(arg.getValue() instanceof UninstantiatedDescribable))).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Restricted(value={NoExternalUse.class})
    public static String getSymbolForDescriptor(Descriptor d) {
        if (d instanceof StepDescriptor) {
            return ((StepDescriptor)d).getFunctionName();
        }
        Set symbols = SymbolLookup.getSymbolValue((Object)d);
        if (!symbols.isEmpty()) {
            return (String)symbols.iterator().next();
        }
        return "(unknown)";
    }

    @Extension(ordinal=925.0)
    public static class DeclarativeOnlineDocsLink
    extends SnippetizerLink {
        @NonNull
        public String getUrl() {
            return "https://jenkins.io/doc/book/pipeline/syntax/";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.DirectiveGenerator_DeclarativeOnlineDocsLink_displayName();
        }

        public boolean inNewWindow() {
            return true;
        }
    }

    @Extension(ordinal=950.0)
    public static class DeclarativeDirectivesLink
    extends SnippetizerLink {
        @NonNull
        public String getUrl() {
            return DirectiveGenerator.ACTION_URL;
        }

        @NonNull
        public String getIcon() {
            return "icon-gear2 icon-md";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.DirectiveGenerator_DeclarativeDirectivesLink_displayName();
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class PerMultiBranchFolderAdder
    extends TransientActionFactory<WorkflowMultiBranchProject> {
        public Class<WorkflowMultiBranchProject> type() {
            return WorkflowMultiBranchProject.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull WorkflowMultiBranchProject target) {
            if (target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new DirectiveGenerator());
            }
            return Collections.emptySet();
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class PerOrgFolderAdder
    extends TransientActionFactory<OrganizationFolder> {
        public Class<OrganizationFolder> type() {
            return OrganizationFolder.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull OrganizationFolder target) {
            if (target.getProjectFactories().get(AbstractWorkflowMultiBranchProjectFactory.class) != null && target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new DirectiveGenerator());
            }
            return Collections.emptySet();
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class PerWorkflowJobAdder
    extends TransientActionFactory<WorkflowJob> {
        public Class<WorkflowJob> type() {
            return WorkflowJob.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull WorkflowJob target) {
            if (target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new DirectiveGenerator());
            }
            return Collections.emptySet();
        }
    }
}

