/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.stapler.DataBoundConstructor;

public class WhenDirective
extends AbstractDirective<WhenDirective> {
    private DeclarativeStageConditional conditional;
    private boolean beforeAgent;
    private boolean beforeInput;
    private boolean beforeOptions;

    @DataBoundConstructor
    public WhenDirective(DeclarativeStageConditional conditional, boolean beforeAgent, boolean beforeInput, boolean beforeOptions) {
        this.conditional = conditional;
        this.beforeAgent = beforeAgent;
        this.beforeInput = beforeInput;
        this.beforeOptions = beforeOptions;
    }

    public DeclarativeStageConditional getConditional() {
        return this.conditional;
    }

    public boolean isBeforeAgent() {
        return this.beforeAgent;
    }

    public boolean isBeforeInput() {
        return this.beforeInput;
    }

    public boolean isBeforeOptions() {
        return this.beforeOptions;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<WhenDirective> {
        @Override
        @NonNull
        public String getName() {
            return "when";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "When Condition";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            return new ArrayList<Descriptor>(DeclarativeStageConditionalDescriptor.forGenerator());
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull WhenDirective directive) {
            UninstantiatedDescribable ud;
            DescribableModel model;
            if (directive.conditional != null && (model = (ud = UninstantiatedDescribable.from((Object)directive.conditional)).getModel()) != null) {
                HashMap args = new HashMap();
                for (String argKey : ud.getArguments().keySet()) {
                    DescribableParameter p = model.getParameter(argKey);
                    if (p != null && !p.isRequired() && String.class.equals((Object)p.getErasedType()) && ud.getArguments().get(argKey).equals("")) continue;
                    args.put(argKey, ud.getArguments().get(argKey));
                }
                StringBuilder result = new StringBuilder();
                result.append("when {\n");
                try {
                    result.append(this.conditionalToGroovy((DeclarativeStageConditional)model.instantiate(args)));
                }
                catch (Exception e) {
                    result.append("// ERROR TRANSLATING CONDITIONAL: ").append(e).append("\n");
                }
                if (directive.isBeforeOptions()) {
                    result.append("beforeOptions true\n");
                }
                if (directive.isBeforeInput()) {
                    result.append("beforeInput true\n");
                }
                if (directive.isBeforeAgent()) {
                    result.append("beforeAgent true\n");
                }
                result.append("}\n");
                return result.toString();
            }
            return "// No valid when condition defined\n";
        }

        @NonNull
        private String conditionalToGroovy(@NonNull DeclarativeStageConditional<?> conditional) {
            DeclarativeStageConditionalDescriptor descriptor = conditional.getDescriptor();
            if (descriptor.getAllowedChildrenCount() == 0) {
                return Snippetizer.object2Groovy((Object)UninstantiatedDescribable.from(conditional)) + "\n";
            }
            StringBuilder result = new StringBuilder();
            result.append(descriptor.getName()).append(" {\n");
            for (DeclarativeStageConditional c : conditional.getChildren()) {
                result.append(this.conditionalToGroovy(c));
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

