/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.BuildOperation;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.KotlinToolchains;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmPlatformToolchain;
import org.jetbrains.kotlin.buildtools.internal.BuildOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.DaemonExecutionPolicyImpl;
import org.jetbrains.kotlin.buildtools.internal.InProcessExecutionPolicyImpl;
import org.jetbrains.kotlin.buildtools.internal.jvm.JvmPlatformToolchainImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\nH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/KotlinToolchainsImpl;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "<init>", "()V", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "toolchains", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$Toolchain;", "getToolchains", "()Ljava/util/concurrent/ConcurrentHashMap;", "getToolchain", "T", "type", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$Toolchain;", "createInProcessExecutionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy$InProcess;", "createDaemonExecutionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy$WithDaemon;", "getCompilerVersion", "", "createBuildSession", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$BuildSession;", "BuildSessionImpl", "kotlin-build-tools-impl"})
public final class KotlinToolchainsImpl
implements KotlinToolchains {
    @NotNull
    private final Map<ProjectId, File> buildIdToSessionFlagFile = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<Class<?>, KotlinToolchains.Toolchain> toolchains = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<Class<?>, KotlinToolchains.Toolchain> getToolchains() {
        return this.toolchains;
    }

    @NotNull
    public <T extends KotlinToolchains.Toolchain> T getToolchain(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        KotlinToolchains.Toolchain toolchain = this.toolchains.computeIfAbsent(type, arg_0 -> KotlinToolchainsImpl.getToolchain$lambda$1(arg_0 -> KotlinToolchainsImpl.getToolchain$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)toolchain, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.buildtools.internal.KotlinToolchainsImpl.getToolchain");
        return (T)toolchain;
    }

    @NotNull
    public ExecutionPolicy.InProcess createInProcessExecutionPolicy() {
        return InProcessExecutionPolicyImpl.INSTANCE;
    }

    @NotNull
    public ExecutionPolicy.WithDaemon createDaemonExecutionPolicy() {
        return new DaemonExecutionPolicyImpl();
    }

    @NotNull
    public String getCompilerVersion() {
        String string = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VERSION");
        return string;
    }

    @NotNull
    public KotlinToolchains.BuildSession createBuildSession() {
        return new BuildSessionImpl(this, (ProjectId)ProjectId.Companion.RandomProjectUUID(), this.buildIdToSessionFlagFile);
    }

    private static final KotlinToolchains.Toolchain getToolchain$lambda$0(KotlinToolchainsImpl this$0, Class type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!Intrinsics.areEqual((Object)type, JvmPlatformToolchain.class)) {
            throw new IllegalStateException(("Unsupported platform toolchain type: " + type + ". Only JVM compilation is supported for now.").toString());
        }
        return (KotlinToolchains.Toolchain)new JvmPlatformToolchainImpl(this$0.buildIdToSessionFlagFile);
    }

    private static final KotlinToolchains.Toolchain getToolchain$lambda$1(Function1 $tmp0, Object p0) {
        return (KotlinToolchains.Toolchain)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J3\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/KotlinToolchainsImpl$BuildSessionImpl;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$BuildSession;", "kotlinToolchains", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "projectId", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "buildIdToSessionFlagFile", "", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;Lorg/jetbrains/kotlin/buildtools/api/ProjectId;Ljava/util/Map;)V", "getKotlinToolchains", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "getProjectId", "()Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "executeOperation", "R", "operation", "Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;", "(Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;)Ljava/lang/Object;", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)Ljava/lang/Object;", "close", "", "clearJarCaches", "kotlin-build-tools-impl"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolchainsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolchainsImpl.kt\norg/jetbrains/kotlin/buildtools/internal/KotlinToolchainsImpl$BuildSessionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
    private static final class BuildSessionImpl
    implements KotlinToolchains.BuildSession {
        @NotNull
        private final KotlinToolchains kotlinToolchains;
        @NotNull
        private final ProjectId projectId;
        @NotNull
        private final Map<ProjectId, File> buildIdToSessionFlagFile;

        public BuildSessionImpl(@NotNull KotlinToolchains kotlinToolchains, @NotNull ProjectId projectId, @NotNull Map<ProjectId, File> buildIdToSessionFlagFile) {
            Intrinsics.checkNotNullParameter((Object)kotlinToolchains, (String)"kotlinToolchains");
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter(buildIdToSessionFlagFile, (String)"buildIdToSessionFlagFile");
            this.kotlinToolchains = kotlinToolchains;
            this.projectId = projectId;
            this.buildIdToSessionFlagFile = buildIdToSessionFlagFile;
        }

        @NotNull
        public KotlinToolchains getKotlinToolchains() {
            return this.kotlinToolchains;
        }

        @NotNull
        public ProjectId getProjectId() {
            return this.projectId;
        }

        public <R> R executeOperation(@NotNull BuildOperation<R> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            return (R)KotlinToolchains.BuildSession.executeOperation$default((KotlinToolchains.BuildSession)this, operation, null, null, (int)2, null);
        }

        public <R> R executeOperation(@NotNull BuildOperation<R> operation, @NotNull ExecutionPolicy executionPolicy, @Nullable KotlinLogger logger) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
            if (!(operation instanceof BuildOperationImpl)) {
                boolean bl = false;
                String string = "Unknown operation type: " + Reflection.getOrCreateKotlinClass(operation.getClass()).getQualifiedName();
                throw new IllegalStateException(string.toString());
            }
            return ((BuildOperationImpl)operation).execute(this.getProjectId(), executionPolicy, logger);
        }

        public void close() {
            this.clearJarCaches();
            File file = this.buildIdToSessionFlagFile.remove(this.getProjectId());
            if (file == null) {
                return;
            }
            File file2 = file;
            file2.delete();
        }

        private final void clearJarCaches() {
            block2: {
                KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
                ZipHandler.clearFileAccessorCache();
                KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
                if (kotlinCoreApplicationEnvironment2 == null) break block2;
                KotlinCoreApplicationEnvironment $this$clearJarCaches_u24lambda_u240 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
                boolean bl = false;
                VirtualFileSystem virtualFileSystem = $this$clearJarCaches_u24lambda_u240.getJarFileSystem();
                CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
                if (coreJarFileSystem != null) {
                    coreJarFileSystem.clearHandlersCache();
                }
                virtualFileSystem = $this$clearJarCaches_u24lambda_u240.getJrtFileSystem();
                CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
                if (coreJrtFileSystem != null) {
                    coreJrtFileSystem.clearRoots();
                }
                $this$clearJarCaches_u24lambda_u240.idleCleanup();
            }
        }
    }
}

