/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.typedGeometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.MultiPolygon;
import jetbrains.datalore.base.typedGeometry.Polygon;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Ring;
import jetbrains.datalore.base.typedGeometry.Vec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t0\b\u001a \u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00062\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t0\b\u001a\"\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\t0\u000e\u00a8\u0006\u000f"}, d2={"bbox", "Ljetbrains/datalore/base/typedGeometry/Rect;", "TypeT", "multiPolygon", "Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "createMultiPolygon", "T", "points", "", "Ljetbrains/datalore/base/typedGeometry/Vec;", "isClockwise", "", "ring", "boundingBox", "", "base-portable"})
public final class AlgorithmsKt {
    public static final <T> boolean isClockwise(@NotNull List<Vec<T>> ring) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        return GeometryKt.isClockwise(ring, (Function1)isClockwise.1.INSTANCE, (Function1)isClockwise.2.INSTANCE);
    }

    @NotNull
    public static final <T> MultiPolygon<T> createMultiPolygon(@NotNull List<Vec<T>> points2) {
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        if (points2.isEmpty()) {
            return new MultiPolygon(CollectionsKt.emptyList());
        }
        ArrayList polygons = new ArrayList();
        ArrayList rings = new ArrayList();
        for (List list2 : GeometryKt.splitRings(points2)) {
            Collection collection = rings;
            boolean bl = false;
            if (!collection.isEmpty() && AlgorithmsKt.isClockwise(list2)) {
                polygons.add(new Polygon(rings));
                rings = new ArrayList();
            }
            rings.add(new Ring(list2));
        }
        Collection collection = rings;
        boolean bl = false;
        if (!collection.isEmpty()) {
            polygons.add(new Polygon(rings));
        }
        return new MultiPolygon(polygons);
    }

    @NotNull
    public static final <TypeT> Rect<TypeT> boundingBox(@NotNull Iterable<Vec<TypeT>> $this$boundingBox) {
        Intrinsics.checkNotNullParameter($this$boundingBox, (String)"<this>");
        return (Rect)DoubleRectangles.INSTANCE.calculateBoundingBox($this$boundingBox, (Function1)boundingBox.1.INSTANCE, (Function1)boundingBox.2.INSTANCE, boundingBox.3.INSTANCE);
    }

    @Nullable
    public static final <TypeT> Rect<TypeT> bbox(@NotNull MultiPolygon<TypeT> multiPolygon) {
        Rect<TypeT> rect2;
        Intrinsics.checkNotNullParameter(multiPolygon, (String)"multiPolygon");
        List<Rect<TypeT>> rects = FunctionsKt.limit(multiPolygon);
        if (rects.isEmpty()) {
            rect2 = null;
        } else {
            Object[] objectArray = new Sequence[]{SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rects), (Function1)bbox.1.INSTANCE), SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rects), (Function1)bbox.2.INSTANCE)};
            rect2 = AlgorithmsKt.boundingBox(SequencesKt.asIterable((Sequence)SequencesKt.flatten((Sequence)SequencesKt.sequenceOf((Object[])objectArray))));
        }
        return rect2;
    }
}

