/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.values;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/base/values/Interval;", "", "lowerBound", "", "upperBound", "(II)V", "length", "getLength", "()I", "getLowerBound", "getUpperBound", "add", "delta", "contains", "", "other", "point", "equals", "hashCode", "intersects", "sub", "toString", "", "union", "base-portable"})
public final class Interval {
    private final int lowerBound;
    private final int upperBound;

    public Interval(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (this.lowerBound > this.upperBound) {
            throw new IllegalArgumentException("Lower bound is greater than upper: lower bound=" + this.lowerBound + ", upper bound=" + this.upperBound);
        }
    }

    public final int getLowerBound() {
        return this.lowerBound;
    }

    public final int getUpperBound() {
        return this.upperBound;
    }

    public final int getLength() {
        return this.upperBound - this.lowerBound;
    }

    public final boolean contains(int point2) {
        return this.lowerBound <= point2 && point2 <= this.upperBound;
    }

    public final boolean contains(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.contains(other.lowerBound) && this.contains(other.upperBound);
    }

    public final boolean intersects(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.contains(other.lowerBound) || other.contains(this.lowerBound);
    }

    @NotNull
    public final Interval union(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = this.lowerBound;
        int n2 = other.lowerBound;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        n = this.upperBound;
        n2 = other.upperBound;
        bl = false;
        return new Interval(n3, Math.max(n, n2));
    }

    @NotNull
    public final Interval add(int delta) {
        return new Interval(this.lowerBound + delta, this.upperBound + delta);
    }

    @NotNull
    public final Interval sub(int delta) {
        return new Interval(this.lowerBound - delta, this.upperBound - delta);
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.lowerBound + ", " + this.upperBound + ']';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)other;
        return this.lowerBound != interval.lowerBound ? false : this.upperBound == interval.upperBound;
    }

    public int hashCode() {
        int result = this.lowerBound;
        result = 31 * result + this.upperBound;
        return result;
    }
}

