/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.builder.SquareFrameOfReference;
import jetbrains.datalore.plot.builder.TileFrameOfReference;
import jetbrains.datalore.plot.builder.TileFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotAxisLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotTileLayout;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProviderFactory;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider;", "Ljetbrains/datalore/plot/builder/TileFrameOfReferenceProvider;", "hScaleProto", "Ljetbrains/datalore/plot/base/Scale;", "", "vScaleProto", "hDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "vDomain", "flipAxis", "", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;ZLjetbrains/datalore/plot/builder/theme/Theme;)V", "getFlipAxis", "()Z", "hAxisLabel", "", "getHAxisLabel", "()Ljava/lang/String;", "hAxisSpec", "Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider$AxisSpec;", "vAxisLabel", "getVAxisLabel", "vAxisSpec", "createFrameOfReference", "Ljetbrains/datalore/plot/builder/TileFrameOfReference;", "layoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "debugDrawing", "createTileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "AxisSpec", "plot-builder-portable"})
public final class SquareFrameOfReferenceProvider
implements TileFrameOfReferenceProvider {
    @NotNull
    private final Scale<Double> hScaleProto;
    @NotNull
    private final Scale<Double> vScaleProto;
    private final boolean flipAxis;
    @NotNull
    private final Theme theme;
    @NotNull
    private final AxisSpec hAxisSpec;
    @NotNull
    private final AxisSpec vAxisSpec;
    @Nullable
    private final String hAxisLabel;
    @Nullable
    private final String vAxisLabel;

    public SquareFrameOfReferenceProvider(@NotNull Scale<Double> hScaleProto, @NotNull Scale<Double> vScaleProto, @NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain, boolean flipAxis, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(hScaleProto, (String)"hScaleProto");
        Intrinsics.checkNotNullParameter(vScaleProto, (String)"vScaleProto");
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.hScaleProto = hScaleProto;
        this.vScaleProto = vScaleProto;
        this.flipAxis = flipAxis;
        this.theme = theme;
        this.hAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.hScaleProto), hDomain, this.hScaleProto.getName(), Theme.DefaultImpls.axisX$default(this.theme, false, 1, null));
        this.vAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.vScaleProto), vDomain, this.vScaleProto.getName(), Theme.DefaultImpls.axisY$default(this.theme, false, 1, null));
        this.hAxisLabel = this.hAxisSpec.getTheme().showTitle() ? this.hAxisSpec.getLabel() : null;
        this.vAxisLabel = this.vAxisSpec.getTheme().showTitle() ? this.vAxisSpec.getLabel() : null;
    }

    @Override
    public boolean getFlipAxis() {
        return this.flipAxis;
    }

    @Override
    @Nullable
    public String getHAxisLabel() {
        return this.hAxisLabel;
    }

    @Override
    @Nullable
    public String getVAxisLabel() {
        return this.vAxisLabel;
    }

    @Override
    @NotNull
    public TileLayout createTileLayout() {
        PlotAxisLayout hAxisLayout = new PlotAxisLayout(this.hAxisSpec.getBreaksProviderFactory(), this.hAxisSpec.getTheme(), Orientation.BOTTOM);
        PlotAxisLayout vAxisLayout = new PlotAxisLayout(this.vAxisSpec.getBreaksProviderFactory(), this.vAxisSpec.getTheme(), Orientation.LEFT);
        ClosedRange<Double> hDomain = this.hAxisSpec.getAesRange();
        ClosedRange<Double> vDomain = this.vAxisSpec.getAesRange();
        return new XYPlotTileLayout(hAxisLayout, vAxisLayout, hDomain, vDomain);
    }

    @Override
    @NotNull
    public TileFrameOfReference createFrameOfReference(@NotNull TileLayoutInfo layoutInfo, @NotNull CoordProvider coordProvider, boolean debugDrawing) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        AxisLayoutInfo axisLayoutInfo = layoutInfo.getXAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo);
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = layoutInfo.getYAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo2);
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        Scale<Double> hScale = coordProvider.buildAxisScaleX(this.hScaleProto, hAxisLayoutInfo.getAxisDomain(), hAxisLayoutInfo.getAxisLength(), hAxisLayoutInfo.getAxisBreaks());
        Scale<Double> vScale = coordProvider.buildAxisScaleY(this.vScaleProto, vAxisLayoutInfo.getAxisDomain(), vAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisBreaks());
        CoordinateSystem coord = coordProvider.createCoordinateSystem(hAxisLayoutInfo.getAxisDomain(), hAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisDomain(), vAxisLayoutInfo.getAxisLength());
        SquareFrameOfReference tileFrameOfReference = new SquareFrameOfReference(hScale, vScale, coord, layoutInfo, this.theme, this.getFlipAxis());
        tileFrameOfReference.setDebugDrawing(debugDrawing);
        return tileFrameOfReference;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider$AxisSpec;", "", "breaksProviderFactory", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "aesRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "label", "", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/lang/String;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "getAesRange", "()Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "getBreaksProviderFactory", "()Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "getLabel", "()Ljava/lang/String;", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "plot-builder-portable"})
    private static final class AxisSpec {
        @NotNull
        private final AxisBreaksProviderFactory breaksProviderFactory;
        @NotNull
        private final ClosedRange<Double> aesRange;
        @Nullable
        private final String label;
        @NotNull
        private final AxisTheme theme;

        public AxisSpec(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @NotNull ClosedRange<Double> aesRange, @Nullable String label, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
            Intrinsics.checkNotNullParameter(aesRange, (String)"aesRange");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            this.breaksProviderFactory = breaksProviderFactory;
            this.aesRange = aesRange;
            this.label = label;
            this.theme = theme;
        }

        @NotNull
        public final AxisBreaksProviderFactory getBreaksProviderFactory() {
            return this.breaksProviderFactory;
        }

        @NotNull
        public final ClosedRange<Double> getAesRange() {
            return this.aesRange;
        }

        @Nullable
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final AxisTheme getTheme() {
            return this.theme;
        }
    }
}

