/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.coord.CoordProviders;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/config/CoordProto;", "", "()V", "createCoordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "defaultProvider", "xLim", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "yLim", "flipped", "", "coordName", "", "options", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "plot-config-portable"})
public final class CoordProto {
    @NotNull
    public static final CoordProto INSTANCE = new CoordProto();

    private CoordProto() {
    }

    @NotNull
    public final CoordProvider createCoordProvider(@NotNull String coordName, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, @NotNull OptionsAccessor options) {
        CoordProvider coordProvider;
        Intrinsics.checkNotNullParameter((Object)coordName, (String)"coordName");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        boolean flipped = OptionsAccessor.getBoolean$default(options, "flip", false, 2, null);
        switch (coordName) {
            case "cartesian": {
                coordProvider = CoordProviders.INSTANCE.cartesian(xLim, yLim, flipped);
                break;
            }
            case "fixed": {
                Double d = options.getDouble("ratio");
                coordProvider = CoordProviders.INSTANCE.fixed(d == null ? 1.0 : d, xLim, yLim, flipped);
                break;
            }
            case "map": {
                coordProvider = CoordProviders.INSTANCE.map(xLim, yLim, flipped);
                break;
            }
            case "flip": {
                throw new IllegalStateException("Don't try to instantiate coord FLIP, it's only a flag.");
            }
            default: {
                throw new IllegalArgumentException("Unknown coordinate system name: '" + coordName + '\'');
            }
        }
        return coordProvider;
    }

    @NotNull
    public final CoordProvider createCoordProvider(@NotNull CoordProvider defaultProvider, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
        return defaultProvider.with(xLim, yLim, flipped);
    }
}

