/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.data.OrderOptionUtil;
import jetbrains.datalore.plot.builder.scale.ScaleProvider;
import jetbrains.datalore.plot.config.DataMetaUtil;
import jetbrains.datalore.plot.config.FacetConfig;
import jetbrains.datalore.plot.config.LayerConfig;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.config.ScaleConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 12\u00020\u0001:\u00011B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006JN\u0010$\u001a\u00020\u00122\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u001e\u001a\u00020\u001d2\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0011H$J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u001e\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00160\u00112\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001dH\u0004R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Ljetbrains/datalore/plot/config/PlotConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "opts", "", "", "", "(Ljava/util/Map;)V", "containsLiveMap", "", "getContainsLiveMap", "()Z", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "getFacets", "()Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "isClientSide", "layerConfigs", "", "Ljetbrains/datalore/plot/config/LayerConfig;", "getLayerConfigs", "()Ljava/util/List;", "scaleConfigs", "Ljetbrains/datalore/plot/config/ScaleConfig;", "getScaleConfigs", "scaleMap", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "getScaleMap", "()Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "<set-?>", "Ljetbrains/datalore/plot/base/DataFrame;", "sharedData", "getSharedData", "()Ljetbrains/datalore/plot/base/DataFrame;", "title", "getTitle", "()Ljava/lang/String;", "createLayerConfig", "layerOptions", "plotMappings", "plotDiscreteAes", "", "plotOrderOptions", "Ljetbrains/datalore/plot/builder/data/OrderOptionUtil$OrderOption;", "createLayerConfigs", "createScaleConfigs", "scaleOptionsList", "replaceSharedData", "", "plotData", "Companion", "plot-config-portable"})
public abstract class PlotConfig
extends OptionsAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LayerConfig> layerConfigs;
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final TypedScaleMap scaleMap;
    @NotNull
    private final List<ScaleConfig<?>> scaleConfigs;
    @NotNull
    private DataFrame sharedData;
    @NotNull
    private static final String ERROR_MESSAGE = "__error_message";
    @NotNull
    private static final Map<String, Object> DEF_OPTIONS = MapsKt.emptyMap();
    @NotNull
    public static final String PLOT_COMPUTATION_MESSAGES = "computation_messages";

    public PlotConfig(@NotNull Map<String, ? extends Object> opts) {
        PlotFacets plotFacets;
        DataFrame plotData;
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        super(opts, DEF_OPTIONS);
        Pair<Map<?, ?>, DataFrame> pair2 = DataMetaUtil.INSTANCE.createDataFrame(this, DataFrame.Builder.Companion.emptyFrame(), SetsKt.emptySet(), MapsKt.emptyMap(), this.isClientSide());
        Map plotMappings = (Map)pair2.component1();
        this.sharedData = plotData = (DataFrame)pair2.component2();
        if (!this.isClientSide()) {
            this.update("mapping", plotMappings);
        }
        this.layerConfigs = this.createLayerConfigs(this.sharedData);
        boolean excludeStatVariables = !this.isClientSide();
        this.scaleConfigs = this.createScaleConfigs(CollectionsKt.plus((Collection)this.getList("scales"), (Iterable)DataMetaUtil.INSTANCE.createScaleSpecs(opts)));
        Map<Aes<?>, ScaleProvider<?>> scaleProviderByAes = PlotConfigUtil.INSTANCE.createScaleProviders$plot_config_portable(this.layerConfigs, this.scaleConfigs, excludeStatVariables);
        Map<Aes<?>, Transform> transformsByAes = PlotConfigUtil.INSTANCE.createTransforms$plot_config_portable(this.layerConfigs, scaleProviderByAes, excludeStatVariables);
        this.scaleMap = PlotConfigUtil.INSTANCE.createScales$plot_config_portable(this.layerConfigs, transformsByAes, scaleProviderByAes, excludeStatVariables);
        PlotConfig plotConfig = this;
        if (this.has("facet")) {
            Map<String, Object> facetOptions = this.getMap("facet");
            FacetConfig facetConfig = new FacetConfig(facetOptions);
            ArrayList<DataFrame> dataByLayer = new ArrayList<DataFrame>();
            Iterator<LayerConfig> iterator2 = this.layerConfigs.iterator();
            PlotConfig plotConfig2 = plotConfig;
            while (iterator2.hasNext()) {
                LayerConfig layerConfig = iterator2.next();
                dataByLayer.add(layerConfig.getCombinedData());
            }
            plotConfig = plotConfig2;
            plotFacets = facetConfig.createFacets((List<DataFrame>)dataByLayer);
        } else {
            plotFacets = PlotFacets.Companion.undefined();
        }
        plotConfig.facets = plotFacets;
    }

    @NotNull
    public final List<LayerConfig> getLayerConfigs() {
        return this.layerConfigs;
    }

    @NotNull
    public final PlotFacets getFacets() {
        return this.facets;
    }

    @NotNull
    public final TypedScaleMap getScaleMap() {
        return this.scaleMap;
    }

    @NotNull
    protected final List<ScaleConfig<?>> getScaleConfigs() {
        return this.scaleConfigs;
    }

    @NotNull
    protected final DataFrame getSharedData() {
        return this.sharedData;
    }

    @Nullable
    public final String getTitle() {
        return (String)this.getMap("ggtitle").get("text");
    }

    protected boolean isClientSide() {
        return false;
    }

    public final boolean getContainsLiveMap() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.layerConfigs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LayerConfig p0 = (LayerConfig)element$iv;
                    boolean bl2 = false;
                    if (!p0.isLiveMap()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<ScaleConfig<Object>> createScaleConfigs(@NotNull List<?> scaleOptionsList) {
        Intrinsics.checkNotNullParameter(scaleOptionsList, (String)"scaleOptionsList");
        HashMap mergedOpts = new HashMap();
        for (Object opts : scaleOptionsList) {
            if (opts == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map optsMap = (Map)opts;
            Aes<?> aes = ScaleConfig.Companion.aesOrFail(optsMap);
            if (!mergedOpts.containsKey(aes)) {
                Map map2 = mergedOpts;
                HashMap hashMap = new HashMap();
                boolean bl = false;
                map2.put(aes, hashMap);
            }
            Object v = mergedOpts.get(aes);
            Intrinsics.checkNotNull(v);
            ((Map)v).putAll(optsMap);
        }
        ArrayList result = new ArrayList();
        for (Map scaleOptions : mergedOpts.values()) {
            Intrinsics.checkNotNullExpressionValue((Object)scaleOptions, (String)"scaleOptions");
            result.add(new ScaleConfig(scaleOptions));
        }
        return result;
    }

    private final List<LayerConfig> createLayerConfigs(DataFrame sharedData) {
        ArrayList<LayerConfig> layerConfigs = new ArrayList<LayerConfig>();
        List<?> layerOptionsList = this.getList("layers");
        for (Object layerOptions : layerOptionsList) {
            boolean bl = layerOptions instanceof Map;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                Object obj = layerOptions;
                Intrinsics.checkNotNull(obj);
                String string = Intrinsics.stringPlus((String)"Layer options: expected Map but was ", (Object)Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName());
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (layerOptions == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map cfr_ignored_0 = (Map)layerOptions;
            LayerConfig layerConfig = this.createLayerConfig((Map)layerOptions, sharedData, this.getMap("mapping"), DataMetaUtil.INSTANCE.getAsDiscreteAesSet(this.getMap("data_meta")), DataMetaUtil.INSTANCE.getOrderOptions(this.getMergedOptions(), this.getMap("mapping")));
            layerConfigs.add(layerConfig);
        }
        return layerConfigs;
    }

    @NotNull
    protected abstract LayerConfig createLayerConfig(@NotNull Map<String, ? extends Object> var1, @NotNull DataFrame var2, @NotNull Map<?, ?> var3, @NotNull Set<?> var4, @NotNull List<OrderOptionUtil.OrderOption> var5);

    protected final void replaceSharedData(@NotNull DataFrame plotData) {
        Intrinsics.checkNotNullParameter((Object)plotData, (String)"plotData");
        boolean bl = !this.isClientSide();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.sharedData = plotData;
        this.update("data", DataFrameUtil.INSTANCE.toMap(plotData));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\u000b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u0016\u0010\u0011\u001a\u00020\u00102\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J\u0016\u0010\u0012\u001a\u00020\u00102\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/config/PlotConfig$Companion;", "", "()V", "DEF_OPTIONS", "", "", "ERROR_MESSAGE", "PLOT_COMPUTATION_MESSAGES", "assertPlotSpec", "", "opts", "assertPlotSpecOrErrorMessage", "failure", "message", "getErrorMessage", "isFailure", "", "isGGBunchSpec", "isPlotSpec", "specKind", "plot-config-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> failure(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)PlotConfig.ERROR_MESSAGE, (Object)message));
        }

        public final void assertPlotSpecOrErrorMessage(@NotNull Map<String, ? extends Object> opts) {
            boolean identified;
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            boolean bl = identified = this.isFailure(opts) || this.isPlotSpec(opts) || this.isGGBunchSpec(opts);
            if (!identified) {
                throw new IllegalArgumentException("Invalid root feature kind: absent or unsupported  `kind` key");
            }
        }

        public final void assertPlotSpec(@NotNull Map<String, ? extends Object> opts) {
            boolean identified;
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            boolean bl = identified = this.isPlotSpec(opts) || this.isGGBunchSpec(opts);
            if (!identified) {
                throw new IllegalArgumentException("Invalid root feature kind: absent or unsupported  `kind` key");
            }
        }

        public final boolean isFailure(@NotNull Map<String, ? extends Object> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return opts.containsKey(PlotConfig.ERROR_MESSAGE);
        }

        @NotNull
        public final String getErrorMessage(@NotNull Map<String, ? extends Object> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return String.valueOf(opts.get(PlotConfig.ERROR_MESSAGE));
        }

        public final boolean isPlotSpec(@NotNull Map<?, ?> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return Intrinsics.areEqual((Object)"plot", (Object)this.specKind(opts));
        }

        public final boolean isGGBunchSpec(@NotNull Map<?, ?> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return Intrinsics.areEqual((Object)"ggbunch", (Object)this.specKind(opts));
        }

        @Nullable
        public final Object specKind(@NotNull Map<?, ?> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            Map<?, ?> map2 = opts;
            String string = "kind";
            boolean bl = false;
            return map2.get(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

