/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.TwoValueNode;
import org.jruby.ast.visitor.NodeVisitor;

public class ArgsCatNode
extends Node
implements TwoValueNode {
    private final Node firstNode;
    private final Node secondNode;

    public ArgsCatNode(int line, Node firstNode, Node secondNode) {
        super(line, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgsCatNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }
}

