/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.gems.GemsInstaller;
import de.saumya.mojo.ruby.script.GemScriptFactory;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;

public abstract class AbstractGemMojo
extends AbstractJRubyMojo {
    @Component(hint="zip")
    protected UnArchiver unzip;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Deprecated
    @Parameter(defaultValue="false", property="gem.includeOpenSSL")
    protected boolean includeOpenSSL;
    @Parameter(defaultValue="true", property="gem.includeRubygemsInTestResources")
    protected boolean includeRubygemsInTestResources;
    @Parameter(defaultValue="false", property="gem.includeRubygemsInResources")
    protected boolean includeRubygemsInResources;
    @Parameter(defaultValue="false", property="gem.includeProvidedRubygemsInResources")
    protected boolean includeProvidedRubygemsInResources;
    @Deprecated
    @Parameter(property="gem.includeGemsInResources")
    protected String includeGemsInResources;
    @Parameter(defaultValue="false", property="gem.includeLibDirectoryInResources")
    protected boolean includeLibDirectoryInResources;
    @Parameter(defaultValue="false", property="gem.installRDoc")
    protected boolean installRDoc;
    @Parameter(defaultValue="false", property="gem.installRI")
    protected boolean installRI;
    @Parameter(defaultValue="false", property="gem.useSystem")
    protected boolean gemUseSystem;
    @Parameter(property="gem.homes")
    protected Map<String, String> gemHomes;
    @Parameter(property="gem.home", defaultValue="${project.build.directory}/rubygems")
    protected File gemHome;
    @Parameter(property="gem.path", defaultValue="${project.build.directory}/rubygems")
    protected File gemPath;
    @Parameter(property="gem.binDirectory")
    protected File binDirectory;
    @Deprecated
    @Parameter(defaultValue="false", property="gem.supportNative")
    protected boolean supportNative;
    @Component
    protected GemManager manager;
    protected GemsConfig gemsConfig;
    protected GemsInstaller gemsInstaller;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getBasedir() == null) {
            this.gemHome = new File(this.gemHome.getAbsolutePath().replace("/${project.basedir}/", "/"));
            this.gemPath = new File(this.gemPath.getAbsolutePath().replace("/${project.basedir}/", "/"));
        }
        this.gemsConfig = new GemsConfig();
        try {
            this.gemsConfig.setGemHome(this.gemHome.getCanonicalFile());
            this.gemsConfig.addGemPath(this.gemPath.getCanonicalFile());
        }
        catch (IOException e) {
            this.gemsConfig.setGemHome(this.gemHome);
            this.gemsConfig.addGemPath(this.gemPath);
        }
        if (this.gemUseSystem && (System.getenv("GEM_HOME") == null || System.getenv("GEM_PATH") == null)) {
            this.getLog().warn((CharSequence)"with gemUseSystem set to true and no GEM_HOME and GEM_PATH is set,  then some maven goals might not work as expected");
        }
        this.gemsConfig.setSystemInstall(this.gemUseSystem);
        this.gemsConfig.setAddRdoc(this.installRDoc);
        this.gemsConfig.setAddRI(this.installRI);
        this.gemsConfig.setBinDirectory(this.binDirectory);
        this.gemsConfig.setSkipJRubyOpenSSL(!this.includeOpenSSL || !this.getJrubyVersion().needsOpenSSL());
        super.execute();
    }

    protected ScriptFactory newScriptFactory(Artifact artifact) throws MojoExecutionException {
        try {
            GemScriptFactory factory;
            GemScriptFactory gemScriptFactory = artifact == null ? new GemScriptFactory(this.logger, this.classRealm, null, this.getProjectClasspath(), this.jrubyFork, this.gemsConfig) : (factory = "jruby-core".equals(artifact.getArtifactId()) ? new GemScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.resolveJRubyStdlibArtifact(artifact).getFile(), this.getProjectClasspath(), this.jrubyFork, this.gemsConfig) : new GemScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.getProjectClasspath(), this.jrubyFork, this.gemsConfig));
            if (this.supportNative) {
                factory.addJvmArgs("-Djruby.home=" + this.setupNativeSupport().getAbsolutePath());
            }
            if (this.rubySourceDirectory != null && this.rubySourceDirectory.exists()) {
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add to ruby loadpath: " + this.rubySourceDirectory.getAbsolutePath()));
                }
                factory.addSwitch("-I", this.rubySourceDirectory.getAbsolutePath());
            }
            if (this.libDirectory != null && this.libDirectory.exists()) {
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add to ruby loadpath: " + this.libDirectory.getAbsolutePath()));
                }
                factory.addSwitch("-I", this.libDirectory.getAbsolutePath());
            }
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    private File setupNativeSupport() throws MojoExecutionException {
        File target = new File(this.project.getBuild().getDirectory());
        File jrubyDir = new File(target, "jruby-" + this.getJrubyVersion());
        if (!jrubyDir.exists()) {
            Artifact dist = this.manager.createArtifact("org.jruby", "jruby-dist", this.getJrubyVersion().toString(), "bin", "zip");
            try {
                this.manager.resolve(dist, this.localRepository, this.project.getRemoteArtifactRepositories());
            }
            catch (GemException e) {
                throw new MojoExecutionException("could not setup jruby distribution for native support", (Exception)((Object)e));
            }
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("unzip " + dist.getFile()));
            }
            target.mkdirs();
            this.unzip.setSourceFile(dist.getFile());
            this.unzip.setDestDirectory(target);
            File f = null;
            try {
                this.unzip.extract();
                f = new File(target, "jruby-" + this.getJrubyVersion() + "/bin/jruby");
                Method m = f.getClass().getMethod("setExecutable", Boolean.TYPE);
                m.invoke((Object)f, new Boolean(true));
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("could unzip jruby distribution for native support", (Exception)((Object)e));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("can not set executable flag: " + f.getAbsolutePath() + " (" + e.getMessage() + ")"));
            }
        }
        return jrubyDir;
    }

    protected File gemHome(String base, String key) {
        if (this.gemHomes != null && this.gemHomes.containsKey(key)) {
            return new File(this.gemHomes.get(key));
        }
        return new File(base + "-" + key);
    }

    protected void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, ScriptException {
        String dir;
        File gems;
        Resource resource;
        Resource resource2;
        this.gemsInstaller = new GemsInstaller(this.gemsConfig, this.factory, this.manager);
        File home = this.gemsConfig.getGemHome();
        this.gemsConfig.setBinDirectory(this.gemsConfig.getBinDirectory());
        String base = this.gemsConfig.getGemHome() != null ? this.gemsConfig.getGemHome().getAbsolutePath() : this.project.getBuild().getDirectory() + "/rubygems";
        try {
            String[] SCOPES;
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)"installing gems for compile scope . . .");
            }
            this.gemsInstaller.installPom(this.project, this.localRepository, "compile");
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)"installing gems for runtime scope . . .");
            }
            this.gemsInstaller.installPom(this.project, this.localRepository, "runtime");
            String[] stringArray = SCOPES = new String[]{"provided", "test"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String scope = stringArray[i];
                File gemHome = this.gemHome(base, scope);
                this.gemsConfig.setGemHome(gemHome);
                this.gemsConfig.addGemPath(gemHome);
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("installing gems for " + scope + " scope . . ."));
                }
                this.gemsInstaller.installPom(this.project, this.localRepository, scope);
            }
            File pluginGemHome = this.gemHome(base, this.plugin.getArtifactId());
            this.gemsConfig.setGemHome(pluginGemHome);
            this.gemsConfig.addGemPath(pluginGemHome);
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("installing gems for plugin " + this.plugin.getGroupId() + ":" + this.plugin.getArtifactId() + " . . ."));
            }
            this.gemsInstaller.installGems(this.project, (Collection)this.plugin.getArtifacts(), this.localRepository, this.getRemoteRepos());
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in installing gems", (Exception)((Object)e));
        }
        finally {
            this.gemsConfig.setGemHome(home);
        }
        if (this.includeRubygemsInTestResources) {
            for (File path : this.gemsConfig.getGemPath()) {
                if (!path.exists()) continue;
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add gems to test-classpath from: " + path.getAbsolutePath()));
                }
                resource2 = new Resource();
                resource2.setDirectory(path.getAbsolutePath());
                resource2.addInclude("gems/**");
                resource2.addInclude("specifications/**");
                this.addResource(this.project.getBuild().getTestResources(), resource2);
            }
        }
        if (this.includeProvidedRubygemsInResources) {
            for (File path : this.gemsConfig.getGemPath()) {
                if (!path.exists() || !path.getName().contains("provided")) continue;
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add gems to classpath from: " + path.getAbsolutePath()));
                }
                resource2 = new Resource();
                resource2.setDirectory(path.getAbsolutePath());
                resource2.addInclude("gems/**");
                resource2.addInclude("specifications/**");
                this.addResource(this.project.getBuild().getResources(), resource2);
            }
        }
        if (this.includeRubygemsInResources) {
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("add gems to classpath from: " + home.getAbsolutePath()));
            }
            resource = new Resource();
            resource.setDirectory(home.getAbsolutePath());
            resource.addInclude("gems/**");
            resource.addInclude("specifications/**");
            resource.addExclude("gems/**/*.java");
            this.addResource(this.project.getBuild().getResources(), resource);
        }
        if (this.includeLibDirectoryInResources) {
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("add to classpath: " + this.libDirectory.getAbsolutePath()));
            }
            resource = new Resource();
            resource.setDirectory(this.libDirectory.getAbsolutePath());
            this.addResource(this.project.getBuild().getResources(), resource);
        }
        if (this.includeGemsInResources != null && (gems = new File(dir = "compile".equals(this.includeGemsInResources) ? base : base + "-" + this.includeGemsInResources, "gems")).exists()) {
            for (File g : gems.listFiles()) {
                File lib = new File(g, "lib");
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add to resource: " + lib.getAbsolutePath()));
                }
                Resource resource3 = new Resource();
                resource3.setDirectory(lib.getAbsolutePath());
                this.project.getBuild().getResources().add(resource3);
            }
        }
        try {
            this.executeWithGems();
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in executing with gems", (Exception)((Object)e));
        }
    }

    protected void addResource(List<Resource> resources, Resource resource) {
        String ref = resource.toString();
        for (Resource r : resources) {
            if (!r.toString().equals(ref)) continue;
            return;
        }
        if (this.jrubyVerbose) {
            this.logger.info((CharSequence)("add resource: " + resource));
        }
        resources.add(resource);
    }

    protected abstract void executeWithGems() throws MojoExecutionException, ScriptException, GemException, IOException, MojoFailureException;

    protected List<ArtifactRepository> getRemoteRepos() {
        LinkedList<ArtifactRepository> remotes = new LinkedList<ArtifactRepository>();
        remotes.addAll(this.project.getPluginArtifactRepositories());
        remotes.addAll(this.project.getRemoteArtifactRepositories());
        return remotes;
    }
}

