/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.gem.GemArtifact;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL)
public class InstallMojo
extends AbstractGemMojo {
    @Parameter(property="install.args")
    protected String installArgs = null;
    @Parameter(property="gem")
    protected File gem = null;

    @Override
    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, MojoFailureException {
        Script script = this.factory.newScriptFromJRubyJar("gem").addArg("install");
        if (this.gem == null && this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && this.project.getArtifact().getFile().exists()) {
            GemArtifact gemArtifact = new GemArtifact(this.project);
            if (gemArtifact.isGem()) {
                script.addArg("-l", gemArtifact.getFile());
            }
        } else {
            if (this.gem == null) {
                for (File f : this.launchDirectory().listFiles()) {
                    if (!f.getName().endsWith(".gem")) continue;
                    if (this.gem == null) {
                        this.gem = f;
                        continue;
                    }
                    throw new MojoFailureException("more than one gem file found, use -Dgem=... to specifiy one");
                }
            }
            if (this.gem != null) {
                this.getLog().info((CharSequence)("use gem: " + this.gem));
                script.addArg("-l", this.gem);
            }
        }
        script.addArg((this.installRDoc ? "--" : "--no-") + "rdoc").addArg((this.installRI ? "--" : "--no-") + "ri").addArgs(this.installArgs).addArgs(this.args).execute();
    }
}

