/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.MAINTAINED, since="5.3")
public abstract class DynamicNode {
    private final String displayName;
    private final @Nullable URI testSourceUri;
    private final @Nullable ExecutionMode executionMode;

    DynamicNode(AbstractConfiguration<?> configuration) {
        this.displayName = Preconditions.notBlank((String)configuration.displayName, (String)"displayName must not be null or blank");
        this.testSourceUri = configuration.testSourceUri;
        this.executionMode = configuration.executionMode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Optional<URI> getTestSourceUri() {
        return Optional.ofNullable(this.testSourceUri);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public Optional<ExecutionMode> getExecutionMode() {
        return Optional.ofNullable(this.executionMode);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("displayName", (Object)this.displayName).append("testSourceUri", (Object)this.testSourceUri).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractConfiguration<T extends Configuration<T>>
    implements Configuration<T> {
        private @Nullable String displayName;
        private @Nullable URI testSourceUri;
        private @Nullable ExecutionMode executionMode;

        AbstractConfiguration() {
        }

        @Override
        public T displayName(String displayName) {
            this.displayName = Preconditions.notBlank((String)displayName, (String)"displayName must not be null or blank");
            return this.self();
        }

        @Override
        public T testSourceUri(@Nullable URI testSourceUri) {
            this.testSourceUri = testSourceUri;
            return this.self();
        }

        @Override
        public T executionMode(ExecutionMode executionMode) {
            this.executionMode = (ExecutionMode)((Object)Preconditions.notNull((Object)((Object)executionMode), (String)"executionMode must not be null"));
            return this.self();
        }

        protected abstract T self();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static interface Configuration<T extends Configuration<T>> {
        public T displayName(String var1);

        public T testSourceUri(@Nullable URI var1);

        public T executionMode(ExecutionMode var1);
    }
}

