/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicExtensionContext;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

abstract class DynamicNodeTestDescriptor
extends JupiterTestDescriptor {
    protected final int index;
    private final Optional<Node.ExecutionMode> executionMode;

    DynamicNodeTestDescriptor(UniqueId uniqueId, int index, DynamicNode dynamicNode, @Nullable TestSource testSource, JupiterConfiguration configuration) {
        super(uniqueId, dynamicNode.getDisplayName(), testSource, configuration);
        this.index = index;
        this.executionMode = dynamicNode.getExecutionMode().map(JupiterTestDescriptor::toExecutionMode);
    }

    @Override
    Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.executionMode;
    }

    public String getLegacyReportingName() {
        return this.getParent().map(TestDescriptor::getLegacyReportingName).orElseGet(() -> ((DynamicNodeTestDescriptor)this).getDisplayName()) + "[" + this.index + "]";
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        DynamicExtensionContext extensionContext = new DynamicExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfiguration(), (ExtensionRegistry)context.getExtensionRegistry(), context.getLauncherStoreFacade());
        return context.extend().withExtensionContext(extensionContext).build();
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) {
        return Node.SkipResult.doNotSkip();
    }
}

