/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.utils.StringUtil;

public class ApplianceBootstrap {
    private final KeycloakSession session;

    public ApplianceBootstrap(KeycloakSession session) {
        this.session = session;
    }

    public boolean isNewInstall() {
        return this.session.realms().getRealmByName(Config.getAdminRealm()) == null;
    }

    public boolean isNoMasterUser() {
        RealmModel realm = this.session.realms().getRealmByName(Config.getAdminRealm());
        return this.session.users().getUsersCount(realm) == 0;
    }

    public boolean createMasterRealm() {
        if (!this.isNewInstall()) {
            throw new IllegalStateException("Can't create default realm as realms already exists");
        }
        String adminRealmName = Config.getAdminRealm();
        ServicesLogger.LOGGER.initializingAdminRealm(adminRealmName);
        RealmManager manager = new RealmManager(this.session);
        RealmModel realm = manager.createRealm(adminRealmName);
        realm.setName(adminRealmName);
        realm.setDisplayName("Keycloak");
        realm.setDisplayNameHtml("<div class=\"kc-logo-text\"><span>Keycloak</span></div>");
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.setDefaultSignatureAlgorithm("RS256");
        realm.setSsoSessionIdleTimeout(1800);
        realm.setAccessTokenLifespan(60);
        realm.setAccessTokenLifespanForImplicitFlow(900);
        realm.setSsoSessionMaxLifespan(36000);
        realm.setOfflineSessionIdleTimeout(2592000);
        realm.setOfflineSessionMaxLifespanEnabled(false);
        realm.setOfflineSessionMaxLifespan(5184000);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setAccessCodeLifespanLogin(1800);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setRegistrationAllowed(false);
        realm.setRegistrationEmailAsUsername(false);
        this.session.getContext().setRealm(realm);
        DefaultKeyProviders.createProviders((RealmModel)realm);
        UserProfileProvider UserProfileProvider2 = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UPConfig upConfig = UserProfileProvider2.getConfiguration();
        for (UPAttribute attr : upConfig.getAttributes()) {
            if ("username".equals(attr.getName())) continue;
            attr.setRequired(null);
        }
        UserProfileProvider2.setConfiguration(upConfig);
        return true;
    }

    public boolean createTemporaryMasterRealmAdminUser(String username, String password, boolean initialUser) {
        RealmModel realm = this.session.realms().getRealmByName(Config.getAdminRealm());
        this.session.getContext().setRealm(realm);
        String string = username = StringUtil.isBlank((String)username) ? "temp-admin" : username;
        if (initialUser && this.session.users().getUsersCount(realm) > 0) {
            ServicesLogger.LOGGER.addAdminUserFailedUsersExist(Config.getAdminRealm());
            return false;
        }
        try {
            UserModel adminUser = this.session.users().addUser(realm, username);
            adminUser.setEnabled(true);
            adminUser.setSingleAttribute("is_temporary_admin", Boolean.TRUE.toString());
            PasswordUserCredentialModel usrCredModel = UserCredentialModel.password((String)password);
            adminUser.credentialManager().updateCredential((CredentialInput)usrCredModel);
            RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
            adminUser.grantRole(adminRole);
            ServicesLogger.LOGGER.createdTemporaryAdminUser(username);
        }
        catch (ModelDuplicateException e) {
            ServicesLogger.LOGGER.addUserFailedUserExists(username, Config.getAdminRealm());
            return false;
        }
        return true;
    }

    public boolean createTemporaryMasterRealmAdminService(String clientId, String clientSecret) {
        RealmModel realm = this.session.realms().getRealmByName(Config.getAdminRealm());
        this.session.getContext().setRealm(realm);
        clientId = StringUtil.isBlank((String)clientId) ? "temp-admin" : clientId;
        ClientRepresentation adminClient = new ClientRepresentation();
        adminClient.setClientId(clientId);
        adminClient.setEnabled(Boolean.valueOf(true));
        adminClient.setServiceAccountsEnabled(Boolean.valueOf(true));
        adminClient.setStandardFlowEnabled(Boolean.valueOf(false));
        adminClient.setPublicClient(Boolean.valueOf(false));
        adminClient.setSecret(clientSecret);
        try {
            ClientModel adminClientModel = ClientManager.createClient(this.session, realm, adminClient);
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(adminClientModel);
            UserModel serviceAccount = this.session.users().getServiceAccount(adminClientModel);
            RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
            serviceAccount.grantRole(adminRole);
            adminClientModel.setAttribute("client.use.lightweight.access.token.enabled", Boolean.TRUE.toString());
            adminClientModel.setAttribute("is_temporary_admin", Boolean.TRUE.toString());
            ServicesLogger.LOGGER.createdTemporaryAdminService(clientId);
        }
        catch (ModelDuplicateException e) {
            ServicesLogger.LOGGER.addClientFailedClientExists(clientId, Config.getAdminRealm());
            return false;
        }
        return true;
    }

    public void createMasterRealmUser(String username, String password) {
        this.createTemporaryMasterRealmAdminUser(username, password, true);
    }
}

