/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.protocol.mappers.oidc;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.keycloak.common.util.TriFunction;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeDecorator;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public enum OrganizationScope {
    ALL("*"::equals, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        if (user == null) {
            return Stream.empty();
        }
        return Organizations.getProvider(session).getByMember(user);
    }), organizations -> true, (TriFunction<KeycloakSession, String, String, String>)((TriFunction)(session, current, previous) -> OrganizationScope.valueOfScope(session, current) == null ? previous : current)),
    SINGLE(StringUtil::isNotBlank, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        OrganizationModel organization = OrganizationScope.parseScopeParameter(session, scopes).map(scope -> OrganizationScope.parseScopeValue(session, scope)).map(alias -> Organizations.getProvider(session).getByAlias(alias)).filter(Objects::nonNull).findAny().orElse(null);
        if (organization == null) {
            return Stream.empty();
        }
        if (user == null || organization.isMember(user)) {
            return Stream.of(organization);
        }
        return Stream.empty();
    }), organizations -> organizations.findAny().isPresent(), (TriFunction<KeycloakSession, String, String, String>)((TriFunction)(session, current, previous) -> {
        if (current.equals(previous)) {
            return current;
        }
        if (ALL.equals((Object)OrganizationScope.valueOfScope(session, current))) {
            return previous;
        }
        return null;
    })),
    ANY(""::equals, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        if (user == null) {
            return Stream.empty();
        }
        List organizations = Organizations.getProvider(session).getByMember(user).toList();
        if (organizations.size() == 1) {
            return organizations.stream();
        }
        ClientSessionContext context = (ClientSessionContext)session.getAttribute(ClientSessionContext.class.getName());
        if (context == null) {
            return Stream.empty();
        }
        AuthenticatedClientSessionModel clientSession = context.getClientSession();
        String orgId = clientSession.getNote("kc.org");
        if (orgId == null) {
            return Stream.empty();
        }
        return organizations.stream().filter(o -> o.getId().equals(orgId));
    }), organizations -> true, (TriFunction<KeycloakSession, String, String, String>)((TriFunction)(session, current, previous) -> {
        if (current.equals(previous)) {
            return current;
        }
        if (ALL.equals((Object)OrganizationScope.valueOfScope(session, current))) {
            return previous;
        }
        return null;
    }));

    private static final String ORGANIZATION_SCOPES_SESSION_ATTRIBUTE = "kc.org.client.scope";
    private static final String UNSUPPORTED_ORGANIZATION_SCOPES_ATTRIBUTE = "kc.org.client.scope.unsupported";
    private static final char VALUE_SEPARATOR = ':';
    private static final Pattern SCOPE_PATTERN;
    private static final String EMPTY_SCOPE = "";
    private final Predicate<String> valueMatcher;
    private final TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>> valueResolver;
    private final Predicate<Stream<OrganizationModel>> valueValidator;
    private final TriFunction<KeycloakSession, String, String, String> nameResolver;

    private OrganizationScope(Predicate<String> valueMatcher, TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>> valueResolver, Predicate<Stream<OrganizationModel>> valueValidator, TriFunction<KeycloakSession, String, String, String> nameResolver) {
        this.valueMatcher = valueMatcher;
        this.valueResolver = valueResolver;
        this.valueValidator = valueValidator;
        this.nameResolver = nameResolver;
    }

    public Stream<OrganizationModel> resolveOrganizations(UserModel user, String scope, KeycloakSession session) {
        return ((Stream)this.valueResolver.apply((Object)user, (Object)Optional.ofNullable(scope).orElse(EMPTY_SCOPE), (Object)session)).filter(OrganizationModel::isEnabled);
    }

    public Stream<OrganizationModel> resolveOrganizations(UserModel user, KeycloakSession session) {
        return this.resolveOrganizations(user, OrganizationScope.getRequestedScopes(session), session);
    }

    public Stream<OrganizationModel> resolveOrganizations(KeycloakSession session) {
        return this.resolveOrganizations(null, session);
    }

    public ClientScopeModel toClientScope(String name, UserModel user, KeycloakSession session) {
        OrganizationScope scope = OrganizationScope.valueOfScope(session, name);
        if (scope == null) {
            return null;
        }
        Stream<OrganizationModel> organizations = scope.resolveOrganizations(user, name, session);
        if (this.valueValidator.test(organizations)) {
            return new ClientScopeDecorator(OrganizationScope.resolveClientScope(session, name), name);
        }
        return null;
    }

    public String resolveName(KeycloakSession session, Set<String> scopes, String previous) {
        for (String scope : scopes) {
            String resolved = (String)this.nameResolver.apply((Object)session, (Object)scope, (Object)previous);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public static OrganizationScope valueOfScope(KeycloakSession session, String rawScope) {
        return OrganizationScope.parseScopeParameter(session, Optional.ofNullable(rawScope).orElse(EMPTY_SCOPE)).map(s -> {
            for (OrganizationScope scope : OrganizationScope.values()) {
                if (!scope.valueMatcher.test(OrganizationScope.parseScopeValue(session, s))) continue;
                return scope;
            }
            return null;
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static OrganizationScope valueOfScope(KeycloakSession session) {
        OrganizationScope value = (OrganizationScope)((Object)session.getAttribute(OrganizationScope.class.getName(), OrganizationScope.class));
        if (value != null) {
            return value;
        }
        value = OrganizationScope.valueOfScope(session, OrganizationScope.getRequestedScopes(session));
        if (value != null) {
            session.setAttribute(OrganizationScope.class.getName(), (Object)value);
        }
        return value;
    }

    private static String getRequestedScopes(KeycloakSession session) {
        AuthenticationSessionModel authSession = session.getContext().getAuthenticationSession();
        if (authSession == null) {
            return EMPTY_SCOPE;
        }
        String requestedScopes = authSession.getClientNote("scope");
        return Optional.ofNullable(requestedScopes).orElse(EMPTY_SCOPE);
    }

    private static String parseScopeValue(KeycloakSession session, String scope) {
        ClientScopeModel clientScope = OrganizationScope.resolveClientScope(session, scope);
        if (clientScope != null && scope.equals(clientScope.getName())) {
            return EMPTY_SCOPE;
        }
        Matcher matcher = SCOPE_PATTERN.matcher(scope);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private static Stream<String> parseScopeParameter(KeycloakSession session, String rawScope) {
        return TokenManager.parseScopeParameter(rawScope).filter(scope -> OrganizationScope.resolveClientScope(session, scope) != null);
    }

    private static ClientScopeModel resolveClientScope(KeycloakSession session, String scope) {
        ClientScopeModel clientScope2;
        if (StringUtil.isBlank((String)scope)) {
            return null;
        }
        ClientModel client = session.getContext().getClient();
        if (client == null) {
            return null;
        }
        if (((Set)session.getAttributeOrDefault(UNSUPPORTED_ORGANIZATION_SCOPES_ATTRIBUTE, Set.of())).contains(scope)) {
            return null;
        }
        Set<Object> organizationScopes = (HashSet<ClientScopeModel>)session.getAttributeOrDefault(ORGANIZATION_SCOPES_SESSION_ATTRIBUTE, Set.of());
        for (ClientScopeModel clientScope2 : organizationScopes) {
            if (!scope.equals(clientScope2.getName()) && !scope.startsWith(clientScope2.getName() + ":")) continue;
            return clientScope2;
        }
        Matcher matcher = SCOPE_PATTERN.matcher(scope);
        if (matcher.matches()) {
            scope = matcher.group(1);
        }
        if ((clientScope2 = OrganizationScope.getClientScope(client, scope)) != null) {
            Stream<String> mappers = clientScope2.getProtocolMappersStream().map(ProtocolMapperModel::getProtocolMapper);
            if (mappers.noneMatch("oidc-organization-membership-mapper"::equals)) {
                HashSet<String> nonOrganizationScopes = (HashSet<String>)session.getAttributeOrDefault(UNSUPPORTED_ORGANIZATION_SCOPES_ATTRIBUTE, Set.of());
                if (nonOrganizationScopes.isEmpty()) {
                    nonOrganizationScopes = new HashSet<String>();
                }
                nonOrganizationScopes.add(scope);
                session.setAttribute(UNSUPPORTED_ORGANIZATION_SCOPES_ATTRIBUTE, nonOrganizationScopes);
                return null;
            }
            organizationScopes = (Set)session.getAttributeOrDefault(ORGANIZATION_SCOPES_SESSION_ATTRIBUTE, Set.of());
            if (organizationScopes.isEmpty()) {
                organizationScopes = new HashSet<ClientScopeModel>();
            }
            organizationScopes.add(clientScope2);
            session.setAttribute(ORGANIZATION_SCOPES_SESSION_ATTRIBUTE, organizationScopes);
        }
        return clientScope2;
    }

    private static ClientScopeModel getClientScope(ClientModel client, String scope) {
        ClientScopeModel clientScope = (ClientScopeModel)client.getClientScopes(false).get(scope);
        if (clientScope == null) {
            clientScope = (ClientScopeModel)client.getClientScopes(true).get(scope);
        }
        return clientScope;
    }

    static {
        SCOPE_PATTERN = Pattern.compile("(.*):(.*)");
    }
}

