/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentFactoryProvider;
import org.keycloak.component.ComponentFactoryProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderEventManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerDeployer;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.provider.Spi;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.theme.DefaultThemeManagerFactory;

public abstract class DefaultKeycloakSessionFactory
implements KeycloakSessionFactory,
ProviderManagerDeployer {
    private static final Logger logger = Logger.getLogger(DefaultKeycloakSessionFactory.class);
    protected Set<Spi> spis = new HashSet<Spi>();
    protected Map<Class<? extends Provider>, String> provider = new HashMap<Class<? extends Provider>, String>();
    protected volatile Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
    protected CopyOnWriteArrayList<ProviderEventListener> listeners = new CopyOnWriteArrayList();
    private final DefaultThemeManagerFactory themeManagerFactory = new DefaultThemeManagerFactory();
    protected long serverStartupTimestamp;
    protected ComponentFactoryProviderFactory componentFactoryPF;

    public void register(ProviderEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ProviderEventListener listener) {
        this.listeners.remove(listener);
    }

    public void publish(ProviderEvent event) {
        for (ProviderEventListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.serverStartupTimestamp = System.currentTimeMillis();
        ProviderManager pm = new ProviderManager(KeycloakDeploymentInfo.create().services(), this.getClass().getClassLoader(), Config.scope((String[])new String[0]).getArray("providers"));
        for (Spi spi : pm.loadSpis()) {
            if (!spi.isEnabled()) continue;
            this.spis.add(spi);
        }
        this.factoriesMap = this.loadFactories(pm);
        ProviderManagerRegistry providerManagerRegistry = ProviderManagerRegistry.SINGLETON;
        synchronized (providerManagerRegistry) {
            for (ProviderManager manager : ProviderManagerRegistry.SINGLETON.getPreBoot()) {
                Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = this.loadFactories(manager);
                for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : factoryMap.entrySet()) {
                    Map<String, ProviderFactory> factories = this.factoriesMap.get(entry.getKey());
                    if (factories == null) {
                        this.factoriesMap.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    factories.putAll(entry.getValue());
                }
            }
            this.checkProvider();
            this.initProviderFactories();
            ProviderManagerRegistry.SINGLETON.setDeployer(this);
        }
        AdminPermissions.registerListener((ProviderEventManager)this);
    }

    protected void initProviderFactories() {
        this.initProviderFactories(true, this.factoriesMap);
    }

    protected void initProviderFactories(boolean updateComponentFactory, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factories) {
        if (updateComponentFactory) {
            this.updateComponentFactoryProviderFactory();
            if (this.componentFactoryPF != null) {
                this.componentFactoryPF.postInit((KeycloakSessionFactory)this);
            }
        }
        HashSet<Class<? extends Provider>> initializedProviders = new HashSet<Class<? extends Provider>>();
        Stack<ProviderFactory> recursionPrevention = new Stack<ProviderFactory>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> f : factories.entrySet()) {
            if (initializedProviders.contains(f.getKey())) continue;
            this.initializeProviders(f.getKey(), factories, initializedProviders, recursionPrevention);
        }
    }

    private void initializeProviders(Class<? extends Provider> provider, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factories, Set<Class<? extends Provider>> intializedProviders, Stack<ProviderFactory> recursionPrevention) {
        for (ProviderFactory factory : factories.get(provider).values()) {
            if (factory == this.componentFactoryPF) continue;
            for (Class providerDep : factory.dependsOn()) {
                if (recursionPrevention.contains(factory)) {
                    List<String> stackForException = recursionPrevention.stream().map(providerFactory -> providerFactory.getClass().getName()).toList();
                    throw new RuntimeException("Detected a recursive dependency on provider " + providerDep.getName() + " while the initialization of the following provider factories is ongoing: " + String.valueOf(stackForException));
                }
                Map<String, ProviderFactory> f = factories.get(providerDep);
                if (f == null) {
                    throw new RuntimeException("No provider factories exists for provider " + providerDep.getSimpleName() + " required by " + factory.getClass().getName() + " (" + factory.getId() + ")");
                }
                recursionPrevention.push(factory);
                this.initializeProviders(providerDep, factories, intializedProviders, recursionPrevention);
                recursionPrevention.pop();
            }
            factory.postInit((KeycloakSessionFactory)this);
            intializedProviders.add(provider);
        }
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> getFactoriesCopy() {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> copy = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : this.factoriesMap.entrySet()) {
            HashMap<String, ProviderFactory> valCopy = new HashMap<String, ProviderFactory>(entry.getValue());
            copy.put(entry.getKey(), valCopy);
        }
        return copy;
    }

    @Override
    public void deploy(ProviderManager pm) {
        this.registerNewSpis(pm);
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> newFactories = this.loadFactories(pm);
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> deployed = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : newFactories.entrySet()) {
            Class<? extends Provider> provider = entry.getKey();
            Map<String, ProviderFactory> current = copy.get(provider);
            if (current == null) {
                copy.put(provider, entry.getValue());
                continue;
            }
            for (Map.Entry<String, ProviderFactory> e : entry.getValue().entrySet()) {
                deployed.compute(provider, (k, v) -> {
                    Map map = Objects.requireNonNullElseGet(v, HashMap::new);
                    map.put((String)e.getKey(), (ProviderFactory)e.getValue());
                    return map;
                });
                ProviderFactory old = current.remove(e.getValue().getId());
                if (old == null) continue;
                undeployed.add(old);
            }
            current.putAll(entry.getValue());
        }
        this.factoriesMap = copy;
        this.checkProvider();
        boolean cfChanged = false;
        for (ProviderFactory factory : undeployed) {
            this.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.PROVIDER_FACTORY, factory.getClass());
            factory.close();
            cfChanged |= this.componentFactoryPF == factory;
        }
        this.initProviderFactories(cfChanged, deployed);
        if (pm.getInfo().hasThemes() || pm.getInfo().hasThemeResources()) {
            this.themeManagerFactory.clearCache();
        }
    }

    private void registerNewSpis(ProviderManager pm) {
        Set existingSpiNames = this.spis.stream().map(spi -> spi.getName()).collect(Collectors.toSet());
        this.spis = new HashSet<Spi>(this.spis);
        for (Spi newSpi : pm.loadSpis()) {
            if (existingSpiNames.contains(newSpi.getName())) continue;
            this.spis.add(newSpi);
        }
    }

    @Override
    public void undeploy(ProviderManager pm) {
        logger.debug((Object)"undeploy");
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        MultivaluedHashMap<Class<? extends Provider>, ProviderFactory> factories = pm.getLoadedFactories();
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry entry : factories.entrySet()) {
            Map<String, ProviderFactory> registered = copy.get(entry.getKey());
            for (ProviderFactory factory : (List)entry.getValue()) {
                undeployed.add(factory);
                logger.debugv("undeploying {0} of id {1}", (Object)factory.getClass().getName(), (Object)factory.getId());
                if (registered == null) continue;
                registered.remove(factory.getId());
            }
        }
        this.factoriesMap = copy;
        for (ProviderFactory factory : undeployed) {
            factory.close();
        }
    }

    protected DefaultThemeManagerFactory getThemeManagerFactory() {
        return this.themeManagerFactory;
    }

    protected void checkProvider() {
        this.provider.clear();
        for (Spi spi : this.spis) {
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                if (this.getProviderFactory(spi.getProviderClass(), provider) == null) {
                    throw new RuntimeException("Failed to find provider " + provider + " for " + spi.getName());
                }
                this.provider.put(spi.getProviderClass(), provider);
                continue;
            }
            Map<String, ProviderFactory> factories = this.factoriesMap.get(spi.getProviderClass());
            String defaultProvider = DefaultKeycloakSessionFactory.resolveDefaultProvider(factories, spi);
            if (defaultProvider == null) continue;
            this.provider.put(spi.getProviderClass(), defaultProvider);
        }
    }

    public static String resolveDefaultProvider(Map<String, ProviderFactory> factories, Spi spi) {
        if (factories == null) {
            return null;
        }
        String defaultProvider = Config.getDefaultProvider((String)spi.getName());
        if (defaultProvider != null) {
            if (!factories.containsKey(defaultProvider)) {
                throw new RuntimeException("Failed to find provider " + defaultProvider + " for " + spi.getName());
            }
        } else if (factories.size() == 1) {
            defaultProvider = factories.values().iterator().next().getId();
        } else {
            Optional<ProviderFactory> highestPriority = factories.values().stream().filter(p -> p.order() > 0).max(Comparator.comparing(ProviderFactory::order));
            if (highestPriority.isPresent()) {
                defaultProvider = highestPriority.get().getId();
            } else if (factories.containsKey("default")) {
                defaultProvider = "default";
            }
        }
        if (defaultProvider != null) {
            logger.debugv("Set default provider for {0} to {1}", (Object)spi.getName(), (Object)defaultProvider);
            return defaultProvider;
        }
        logger.debugv("No default provider for {0}", (Object)spi.getName());
        return null;
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> loadFactories(ProviderManager pm) {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        Set<Spi> spiList = this.spis;
        for (Spi spi : spiList) {
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            factoryMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                Config.Scope scope;
                ProviderFactory factory = pm.load(spi, provider);
                if (factory == null || !this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), provider}))) continue;
                factory.init(scope);
                if (spi.isInternal() && !DefaultKeycloakSessionFactory.isInternal(factory)) {
                    ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                }
                factories.put(factory.getId(), factory);
                logger.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            for (ProviderFactory factory : pm.load(spi)) {
                Config.Scope scope;
                if (this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()}))) {
                    factory.init(scope);
                    if (spi.isInternal() && !DefaultKeycloakSessionFactory.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    factories.put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
        }
        return factoryMap;
    }

    protected boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported(scope);
        }
        return true;
    }

    public Set<Spi> getSpis() {
        return this.spis;
    }

    public Spi getSpi(Class<? extends Provider> providerClass) {
        for (Spi spi : this.spis) {
            if (!spi.getProviderClass().equals(providerClass)) continue;
            return spi;
        }
        return null;
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        return this.getProviderFactory(clazz, this.provider.get(clazz));
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        Map<String, ProviderFactory> map = this.factoriesMap.get(clazz);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String realmId, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        return this.componentFactoryPF == null ? null : this.componentFactoryPF.getProviderFactory(clazz, realmId, componentId, modelGetter);
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        this.factoriesMap.values().stream().map(Map::values).flatMap(Collection::stream).filter(InvalidationHandler.class::isInstance).map(InvalidationHandler.class::cast).forEach(ih -> ih.invalidate(session, type, ids));
    }

    public Stream<ProviderFactory> getProviderFactoriesStream(Class<? extends Provider> clazz) {
        if (this.factoriesMap == null) {
            return Stream.empty();
        }
        Map<String, ProviderFactory> providerFactoryMap = this.factoriesMap.get(clazz);
        if (providerFactoryMap == null) {
            return Stream.empty();
        }
        return providerFactoryMap.values().stream();
    }

    <T extends Provider> Set<String> getAllProviderIds(Class<T> clazz) {
        Map<String, ProviderFactory> factoryMap = this.factoriesMap.get(clazz);
        if (factoryMap == null) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        for (ProviderFactory f : factoryMap.values()) {
            ids.add(f.getId());
        }
        return ids;
    }

    Class<? extends Provider> getProviderClass(String providerClassName) {
        for (Class<? extends Provider> clazz : this.factoriesMap.keySet()) {
            if (!clazz.getName().equals(providerClassName)) continue;
            return clazz;
        }
        return null;
    }

    public void close() {
        ProviderManagerRegistry.SINGLETON.setDeployer(null);
        HashMap<Class, Node> nodes = new HashMap<Class, Node>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> f : this.factoriesMap.entrySet()) {
            Class<? extends Provider> provider = f.getKey();
            for (Map.Entry<String, ProviderFactory> entry : f.getValue().entrySet()) {
                ProviderFactory pf = entry.getValue();
                Node node = nodes.computeIfAbsent(provider, k -> new Node(new HashSet()));
                ((Set)node.data).add(pf);
                pf.dependsOn().forEach(dep -> {
                    node.parent = nodes.computeIfAbsent((Class)dep, k -> new Node(new HashSet()));
                    node.parent.children.add(node);
                });
            }
        }
        nodes.values().forEach(this::closeProvider);
    }

    private void closeProvider(Node<Set<ProviderFactory>> node) {
        Iterator<Node<Object>> it = node.children.iterator();
        while (it.hasNext()) {
            this.closeProvider(it.next());
            it.remove();
        }
        it = ((Set)node.data).iterator();
        while (it.hasNext()) {
            ProviderFactory pf = (ProviderFactory)it.next();
            logger.debugf("Closing ProviderFactory: %s", (Object)pf.getClass().getName());
            pf.close();
            it.remove();
        }
    }

    public static boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    public long getServerStartupTimestamp() {
        return this.serverStartupTimestamp;
    }

    protected void updateComponentFactoryProviderFactory() {
        this.componentFactoryPF = (ComponentFactoryProviderFactory)this.getProviderFactory(ComponentFactoryProvider.class);
    }

    private static class Node<T> {
        private final T data;
        private Node<T> parent;
        private List<Node<T>> children;

        public Node(T data) {
            this.data = data;
            this.parent = null;
            this.children = new ArrayList<Node<T>>();
        }
    }
}

