/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.mtp;

public enum RoutingLabelFormat {
    ANSI_Sls8Bit("ANSI_Sls8Bit", 8),
    ANSI_Sls5Bit("ANSI_Sls5Bit", 5),
    ITU("ITU", 4),
    Japan_TTC_DDI("Japan_TTC_DDI", 8),
    China("China", 8),
    Japan_NTT("Japan_NTT", 8);

    private final String format;
    private final int slsLengthInBits;
    private final int maxSls;
    private final int slsMsbMask;
    private static final String FORMAT_ITU = "ITU";
    private static final String FORMAT_ANSI = "ANSI";
    private static final String FORMAT_Japan_TTC_DDI = "Japan_TTC_DDI";
    private static final String FROMAT_China = "China";
    private static final String FORMAT_Japan_NTT = "Japan_NTT";
    private static final int SLS_LSB_MASK = 1;

    private RoutingLabelFormat(String format, int slsLengthInBits) {
        this.format = format;
        this.slsLengthInBits = slsLengthInBits;
        switch (this.slsLengthInBits) {
            case 8: {
                this.maxSls = 256;
                this.slsMsbMask = 128;
                break;
            }
            case 5: {
                this.maxSls = 32;
                this.slsMsbMask = 16;
                break;
            }
            case 4: {
                this.maxSls = 16;
                this.slsMsbMask = 8;
                break;
            }
            default: {
                this.maxSls = 16;
                this.slsMsbMask = 8;
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public int getSlsLengthInBits() {
        return this.slsLengthInBits;
    }

    public int getMaxSls() {
        return this.maxSls;
    }

    public int getSlsMsbMask() {
        return this.slsMsbMask;
    }

    public int getSlsLsbMask() {
        return 1;
    }

    public static RoutingLabelFormat getInstance(String format) {
        if (FORMAT_ITU.equals(format)) {
            return ITU;
        }
        if (FORMAT_ANSI.equals(format)) {
            return ANSI_Sls8Bit;
        }
        if (FORMAT_Japan_TTC_DDI.equals(format)) {
            return Japan_TTC_DDI;
        }
        if (FROMAT_China.equals(format)) {
            return China;
        }
        if (FORMAT_Japan_NTT.equals(format)) {
            return Japan_NTT;
        }
        return null;
    }
}

