/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.server.rest.dbms.DelegatingPrincipal;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;

public class AuthorizedRequestWrapper
extends HttpServletRequestWrapper {
    private final String authType;
    private final DelegatingPrincipal principal;

    public static LoginContext getLoginContextFromHttpServletRequest(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        ClientConnectionInfo connectionInfo = HttpConnectionInfoFactory.create(request);
        return AuthorizedRequestWrapper.getLoginContextFromUserPrincipal(principal, connectionInfo);
    }

    public static LoginContext getLoginContextFromUserPrincipal(Principal principal, ClientConnectionInfo connectionInfo) {
        if (principal instanceof DelegatingPrincipal) {
            return ((DelegatingPrincipal)principal).getLoginContext();
        }
        return new LoginContext(AuthSubject.ANONYMOUS, connectionInfo){

            public SecurityContext authorize(LoginContext.IdLookup idLookup, String dbName, AbstractSecurityLog securityLog) {
                return new SecurityContext(this.subject(), (AccessMode)AccessMode.Static.ACCESS, this.connectionInfo(), dbName);
            }
        };
    }

    public AuthorizedRequestWrapper(String authType, String username, HttpServletRequest request, LoginContext loginContext) {
        super(request);
        this.authType = authType;
        this.principal = new DelegatingPrincipal(username, loginContext);
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return true;
    }

    public String toString() {
        return "AuthorizedRequestWrapper{authType='" + this.authType + "', principal=" + String.valueOf(this.principal) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AuthorizedRequestWrapper that = (AuthorizedRequestWrapper)((Object)o);
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        return this.principal.equals(that.principal);
    }

    public int hashCode() {
        int result = this.authType.hashCode();
        result = 31 * result + this.principal.hashCode();
        return result;
    }
}

