/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.graphdb.Node;
import org.neo4j.server.http.cypher.CachingWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.NodeValue;

public class SingleNodeRecordHandler
implements RecordHandler {
    private final CachingWriter cachingWriter;
    private final Consumer<Node> nodeConsumer;

    public SingleNodeRecordHandler(CachingWriter cachingWriter, Consumer<Node> nodeConsumer) {
        this.cachingWriter = cachingWriter;
        this.nodeConsumer = nodeConsumer;
    }

    public void onField(AnyValue value) {
        if (value instanceof NodeValue) {
            NodeValue node = (NodeValue)value;
            try {
                node.writeTo((AnyValueWriter)this.cachingWriter);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void onCompleted() {
        this.nodeConsumer.accept((Node)this.cachingWriter.getCachedObject());
    }

    public void onFailure() {
    }
}

