/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.response;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.server.httpv2.request.QueryRequest;

public class DriverResultSerializer {
    private final JsonGenerator jsonGenerator;
    private State currentState = State.ROOT;

    public DriverResultSerializer(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void writeFieldNames(List<String> keys) throws IOException {
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeFieldName("data");
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeArrayFieldStart("fields");
        for (String key : keys) {
            this.jsonGenerator.writeString(key);
        }
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeArrayFieldStart("values");
        this.currentState = State.IN_VALUES;
    }

    public void writeValue(Record record) throws IOException {
        this.jsonGenerator.writeObject((Object)record);
    }

    public void writeError(Neo4jException neo4jException) throws IOException {
        this.ensureResultSetClosedForErrorsWriting();
        this.jsonGenerator.writeFieldName("errors");
        this.jsonGenerator.writeStartArray();
        this.jsonGenerator.writeObject((Object)neo4jException);
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
    }

    public void writeNotifications(List<Notification> notifications) throws IOException {
        if (!notifications.isEmpty()) {
            this.jsonGenerator.writeFieldName("notifications");
            this.jsonGenerator.writeObject(notifications);
        }
    }

    public void finish(ResultSummary resultSummary, Set<Bookmark> bookmarks, QueryRequest queryRequest) throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
        this.writeNotifications(resultSummary.notifications());
        if (queryRequest.includeCounters()) {
            this.writeCounters(resultSummary.counters());
        }
        if (resultSummary.hasPlan() && resultSummary.hasProfile()) {
            this.jsonGenerator.writeFieldName("profiledQueryPlan");
            this.jsonGenerator.writeObject((Object)resultSummary.profile());
        }
        if (resultSummary.hasPlan() && !resultSummary.hasProfile()) {
            this.jsonGenerator.writeFieldName("queryPlan");
            this.jsonGenerator.writeObject((Object)resultSummary.plan());
        }
        this.jsonGenerator.writeArrayFieldStart("bookmarks");
        for (Bookmark bookmark : bookmarks) {
            this.jsonGenerator.writeString(bookmark.value());
        }
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
    }

    private void writeCounters(SummaryCounters counters) throws IOException {
        this.jsonGenerator.writeFieldName("counters");
        this.jsonGenerator.writeObject((Object)counters);
    }

    private void ensureResultSetClosedForErrorsWriting() throws IOException {
        if (this.currentState == State.IN_VALUES) {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
        }
    }

    private static enum State {
        ROOT,
        IN_VALUES;

    }
}

