/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class SessionFactoryImpl
implements SessionFactory {
    private final ConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
    }

    @Override
    public Session newInstance(AccessMode mode, Bookmarks bookmarks) {
        NetworkSession session = this.createSession(this.connectionProvider, this.retryLogic, mode, this.logging);
        session.setBookmarks(bookmarks);
        return session;
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.connectionProvider.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionProvider.close();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private NetworkSession createSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, AccessMode mode, Logging logging) {
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, mode, retryLogic, logging) : new NetworkSession(connectionProvider, mode, retryLogic, logging);
    }
}

