/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.time.Clock;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenAndExpiration;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.LockUtil;

public class ExpirationBasedAuthTokenManager
implements AuthTokenManager {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Supplier<CompletionStage<AuthTokenAndExpiration>> freshTokenSupplier;
    private final Set<Class<? extends SecurityException>> retryableExceptionClasses;
    private final Clock clock;
    private CompletableFuture<AuthToken> tokenFuture;
    private AuthTokenAndExpiration token;

    public ExpirationBasedAuthTokenManager(Supplier<CompletionStage<AuthTokenAndExpiration>> freshTokenSupplier, Set<Class<? extends SecurityException>> retryableExceptionClasses, Clock clock) {
        this.freshTokenSupplier = freshTokenSupplier;
        this.retryableExceptionClasses = retryableExceptionClasses;
        this.clock = clock;
    }

    @Override
    public CompletionStage<AuthToken> getToken() {
        CompletableFuture validTokenFuture = LockUtil.executeWithLock(this.lock.readLock(), this::getValidTokenFuture);
        if (validTokenFuture == null) {
            AtomicBoolean fetchFromUpstream = new AtomicBoolean();
            validTokenFuture = LockUtil.executeWithLock(this.lock.writeLock(), () -> {
                if (this.getValidTokenFuture() == null) {
                    this.tokenFuture = new CompletableFuture();
                    this.token = null;
                    fetchFromUpstream.set(true);
                }
                return this.tokenFuture;
            });
            if (fetchFromUpstream.get()) {
                this.getFromUpstream().whenComplete(this::handleUpstreamResult);
            }
        }
        return validTokenFuture;
    }

    @Override
    public boolean handleSecurityException(AuthToken authToken, SecurityException exception) {
        boolean retryable = this.retryableExceptionClasses.stream().anyMatch(retryableExceptionClass -> retryableExceptionClass.isAssignableFrom(exception.getClass()));
        if (retryable) {
            LockUtil.executeWithLock(this.lock.writeLock(), () -> {
                if (this.token != null && this.token.authToken().equals(authToken)) {
                    this.unsetTokenState();
                }
            });
        }
        return retryable;
    }

    private void handleUpstreamResult(AuthTokenAndExpiration authTokenAndExpiration, Throwable throwable) {
        if (throwable != null) {
            CompletableFuture previousTokenFuture = LockUtil.executeWithLock(this.lock.writeLock(), this::unsetTokenState);
            previousTokenFuture.completeExceptionally(throwable);
        } else if (this.isValid(authTokenAndExpiration)) {
            CompletableFuture previousTokenFuture = LockUtil.executeWithLock(this.lock.writeLock(), this::unsetTokenState);
            previousTokenFuture.completeExceptionally(new IllegalStateException("invalid token served by upstream"));
        } else {
            CompletableFuture currentTokenFuture = LockUtil.executeWithLock(this.lock.writeLock(), () -> {
                this.token = authTokenAndExpiration;
                return this.tokenFuture;
            });
            currentTokenFuture.complete(authTokenAndExpiration.authToken());
        }
    }

    private CompletableFuture<AuthToken> unsetTokenState() {
        CompletableFuture<AuthToken> previousTokenFuture = this.tokenFuture;
        this.tokenFuture = null;
        this.token = null;
        return previousTokenFuture;
    }

    private CompletionStage<AuthTokenAndExpiration> getFromUpstream() {
        CompletionStage<AuthTokenAndExpiration> upstreamStage;
        try {
            upstreamStage = this.freshTokenSupplier.get();
            Objects.requireNonNull(upstreamStage, "upstream supplied a null value");
        }
        catch (Throwable t) {
            upstreamStage = Futures.failedFuture(t);
        }
        return upstreamStage;
    }

    private boolean isValid(AuthTokenAndExpiration token) {
        return token == null || token.expirationTimestamp() < this.clock.millis();
    }

    private CompletableFuture<AuthToken> getValidTokenFuture() {
        CompletableFuture<AuthToken> validTokenFuture = null;
        if (this.tokenFuture != null) {
            long expirationTimestamp;
            validTokenFuture = this.token != null ? ((expirationTimestamp = this.token.expirationTimestamp()) > this.clock.millis() ? this.tokenFuture : null) : this.tokenFuture;
        }
        return validTokenFuture;
    }
}

