/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ConfigValue {
    private final String name;
    private final Optional<String> description;
    private final Optional<String> documentedDefaultValue;
    private final Optional<Object> value;
    private final String valueDescription;
    private final boolean internal;
    private final boolean secret;
    private final boolean dynamic;
    private final boolean deprecated;
    private final Optional<String> replacement;

    public ConfigValue(@Nonnull String name, @Nonnull Optional<String> description, @Nonnull Optional<String> documentedDefaultValue, @Nonnull Optional<Object> value, @Nonnull String valueDescription, boolean internal, boolean dynamic, boolean deprecated, @Nonnull Optional<String> replacement, boolean secret) {
        this.name = name;
        this.description = description;
        this.documentedDefaultValue = documentedDefaultValue;
        this.value = value;
        this.valueDescription = valueDescription;
        this.internal = internal;
        this.secret = secret;
        this.dynamic = dynamic;
        this.deprecated = deprecated;
        this.replacement = replacement;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public Optional<String> description() {
        return this.description;
    }

    @Nonnull
    public Optional<Object> value() {
        return this.value;
    }

    @Nonnull
    public Optional<String> valueAsString() {
        return this.secret() ? Optional.of("##########") : this.value.map(ConfigValue::valueToString);
    }

    public String toString() {
        return this.valueAsString().orElse("null");
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    @Nonnull
    public Optional<String> replacement() {
        return this.replacement;
    }

    public boolean internal() {
        return this.internal;
    }

    public boolean secret() {
        return this.secret;
    }

    public boolean dynamic() {
        return this.dynamic;
    }

    @Nonnull
    public Optional<String> documentedDefaultValue() {
        return this.documentedDefaultValue;
    }

    @Nonnull
    public String valueDescription() {
        return this.valueDescription;
    }

    static String valueToString(Object v) {
        if (v instanceof Duration) {
            Duration d = (Duration)v;
            return String.format("%dms", d.toMillis());
        }
        return String.valueOf(v);
    }
}

