/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.printer;

import java.io.PrintStream;
import java.util.Objects;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.logging.Log;

public class ProgressPrinters {
    private ProgressPrinters() {
    }

    public static OutputProgressPrinter printStreamPrinter(PrintStream printStream) {
        Objects.requireNonNull(printStream);
        return new PrintStreamOutputProgressPrinter(printStream);
    }

    public static OutputProgressPrinter emptyPrinter() {
        return new EmptyOutputProgressPrinter();
    }

    public static OutputProgressPrinter logProviderPrinter(Log log) {
        Objects.requireNonNull(log);
        return new LogOutputProgressPrinter(log);
    }

    private static class LogOutputProgressPrinter
    implements OutputProgressPrinter {
        private final Log log;

        LogOutputProgressPrinter(Log log) {
            this.log = log;
        }

        @Override
        public void print(String message) {
            this.log.info(message);
        }
    }

    private static class PrintStreamOutputProgressPrinter
    implements OutputProgressPrinter {
        private final PrintStream printStream;
        private final boolean interactive;

        PrintStreamOutputProgressPrinter(PrintStream printStream) {
            this.printStream = printStream;
            this.interactive = System.console() != null;
        }

        @Override
        public void print(String message) {
            this.printStream.print(this.lineSeparator() + message);
        }

        @Override
        public void complete() {
            this.printStream.print(System.lineSeparator());
        }

        private char lineSeparator() {
            return this.interactive ? (char)'\r' : '\n';
        }
    }

    private static class EmptyOutputProgressPrinter
    implements OutputProgressPrinter {
        private EmptyOutputProgressPrinter() {
        }

        @Override
        public void print(String message) {
        }
    }
}

