/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

public class LiteDepthFirstSelector
implements BranchSelector {
    private final Queue<TraversalBranch> superNodes = new LinkedList<TraversalBranch>();
    private TraversalBranch current;
    private final int threshold;
    private final PathExpander expander;

    public LiteDepthFirstSelector(TraversalBranch startSource, int startThreshold, PathExpander expander) {
        this.current = startSource;
        this.threshold = startThreshold;
        this.expander = expander;
    }

    public TraversalBranch next(TraversalContext metadata) {
        TraversalBranch result = null;
        while (result == null) {
            TraversalBranch next;
            if (this.current == null) {
                this.current = this.superNodes.poll();
                if (this.current == null) {
                    return null;
                }
            } else if (this.current.expanded() > 0 && this.current.expanded() % this.threshold == 0) {
                this.superNodes.add(this.current);
                this.current = this.current.parent();
                continue;
            }
            if ((next = this.current.next(this.expander, metadata)) == null) {
                this.current = this.current.parent();
                continue;
            }
            result = this.current = next;
        }
        return result;
    }
}

