/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

interface UpgradeLocker {
    public static final UpgradeLocker DEFAULT = new UpgradeLocker(){
        private static final long ID = Long.MAX_VALUE;
        private final ResourceTypes type = ResourceTypes.NODE;

        @Override
        public Lock acquireWriteLock(KernelTransaction tx) {
            final Locks.Client lockClient = this.getLockClient(tx);
            lockClient.acquireExclusive(LockTracer.NONE, (ResourceType)this.type, new long[]{Long.MAX_VALUE});
            return new Lock(){

                public void release() {
                    lockClient.releaseExclusive((ResourceType)type, new long[]{Long.MAX_VALUE});
                }
            };
        }

        @Override
        public Lock acquireReadLock(KernelTransaction tx) {
            final Locks.Client lockClient = this.getLockClient(tx);
            lockClient.acquireShared(LockTracer.NONE, (ResourceType)this.type, new long[]{Long.MAX_VALUE});
            return new Lock(){

                public void release() {
                    lockClient.releaseShared((ResourceType)type, new long[]{Long.MAX_VALUE});
                }
            };
        }

        private Locks.Client getLockClient(KernelTransaction tx) {
            return ((KernelTransactionImplementation)tx).lockClient();
        }
    };

    public Lock acquireWriteLock(KernelTransaction var1);

    public Lock acquireReadLock(KernelTransaction var1);
}

