/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.util.collection.MemoryAllocationLimitException;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class CapacityLimitingBlockAllocatorDecorator
implements OffHeapBlockAllocator {
    private final OffHeapBlockAllocator impl;
    private final long maxMemory;
    private final AtomicLong usedMemory = new AtomicLong();

    public CapacityLimitingBlockAllocatorDecorator(OffHeapBlockAllocator impl, long maxMemory) {
        this.impl = Objects.requireNonNull(impl);
        this.maxMemory = Preconditions.requirePositive((long)maxMemory);
    }

    @Override
    public OffHeapBlockAllocator.MemoryBlock allocate(long size, MemoryTracker tracker) {
        long usedMemoryAfter;
        long usedMemoryBefore;
        do {
            if ((usedMemoryAfter = (usedMemoryBefore = this.usedMemory.get()) + size) <= this.maxMemory) continue;
            throw new MemoryAllocationLimitException(size, usedMemoryBefore, this.maxMemory);
        } while (!this.usedMemory.compareAndSet(usedMemoryBefore, usedMemoryAfter));
        try {
            return this.impl.allocate(size, tracker);
        }
        catch (Throwable t) {
            this.usedMemory.addAndGet(-size);
            throw t;
        }
    }

    @Override
    public void free(OffHeapBlockAllocator.MemoryBlock block, MemoryTracker tracker) {
        try {
            this.impl.free(block, tracker);
        }
        finally {
            this.usedMemory.addAndGet(-block.size);
        }
    }

    @Override
    public void release() {
        try {
            this.impl.release();
        }
        finally {
            this.usedMemory.set(0L);
        }
    }
}

