/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.cache.Static;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class ApocConfiguration {
    public static final String PREFIX = "apoc.";
    private static final Pattern SKIP = Pattern.compile("(ur[il]|pass|cred)", 2);
    private static Map<String, Object> apocConfig = new HashMap<String, Object>(10);
    private static Map<String, Object> config = new HashMap<String, Object>(32);
    private static final Map<String, String> PARAM_WHITELIST = new HashMap<String, String>(2);

    public static void initialize(GraphDatabaseAPI db) {
        Static.clear();
        Map params = ((Config)db.getDependencyResolver().resolveDependency(Config.class)).getRaw();
        apocConfig.clear();
        apocConfig.putAll(Util.subMap(params, PREFIX));
        PARAM_WHITELIST.forEach((k, v) -> apocConfig.put((String)v, params.get(k)));
        config.clear();
        params.forEach((k, v) -> {
            if (!SKIP.matcher((CharSequence)k).find()) {
                config.put((String)k, v);
            }
        });
    }

    public static Map<String, Object> get(String prefix) {
        return Util.subMap(apocConfig, prefix);
    }

    public static <T> T get(String key, T defaultValue) {
        return (T)apocConfig.getOrDefault(key, defaultValue);
    }

    public static boolean isEnabled(String key) {
        return Util.toBoolean(apocConfig.getOrDefault(key, false));
    }

    public static void addToConfig(Map<String, Object> newConfig) {
        apocConfig.putAll(newConfig);
    }

    public static Map<String, Object> list() {
        return config;
    }

    static {
        PARAM_WHITELIST.put("dbms.directories.import", "import.file.directory");
        PARAM_WHITELIST.put("dbms.security.allow_csv_import_from_file_urls", "import.file.allow_read_from_filesystem");
    }
}

