/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfiguration;
import apoc.Pools;
import apoc.index.IndexUpdateTransactionEventHandler;
import apoc.trigger.Trigger;
import apoc.ttl.TTLLifeCycle;
import apoc.util.ApocUrlStreamHandlerFactory;
import java.net.URL;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;

public class ApocKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public ApocKernelExtensionFactory() {
        super("APOC");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        GraphDatabaseAPI db = dependencies.graphdatabaseAPI();
        LogService log = dependencies.log();
        return new ApocLifecycle(log, db, dependencies);
    }

    static {
        URL.setURLStreamHandlerFactory(new ApocUrlStreamHandlerFactory());
    }

    public static class ApocLifecycle
    extends LifecycleAdapter {
        private final LogService log;
        private final GraphDatabaseAPI db;
        private final Dependencies dependencies;
        private Trigger.LifeCycle triggerLifeCycle;
        private Log userLog;
        private TTLLifeCycle ttlLifeCycle;
        private IndexUpdateTransactionEventHandler.LifeCycle indexUpdateLifeCycle;

        public ApocLifecycle(LogService log, GraphDatabaseAPI db, Dependencies dependencies) {
            this.log = log;
            this.db = db;
            this.dependencies = dependencies;
            this.userLog = log.getUserLog(ApocKernelExtensionFactory.class);
        }

        public IndexUpdateTransactionEventHandler.LifeCycle getIndexUpdateLifeCycle() {
            return this.indexUpdateLifeCycle;
        }

        public void start() throws Throwable {
            ApocConfiguration.initialize(this.db);
            Pools.NEO4J_SCHEDULER = this.dependencies.scheduler();
            this.registerCustomProcedures();
            this.ttlLifeCycle = new TTLLifeCycle(Pools.NEO4J_SCHEDULER, this.db, this.log.getUserLog(TTLLifeCycle.class));
            this.ttlLifeCycle.start();
            this.triggerLifeCycle = new Trigger.LifeCycle(this.db, this.log.getUserLog(Trigger.class));
            this.triggerLifeCycle.start();
            this.indexUpdateLifeCycle = new IndexUpdateTransactionEventHandler.LifeCycle(this.db, this.log.getUserLog(Procedures.class));
            this.indexUpdateLifeCycle.start();
        }

        public void registerCustomProcedures() {
        }

        public void stop() throws Throwable {
            if (this.ttlLifeCycle != null) {
                try {
                    this.ttlLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping ttl service", (Throwable)e);
                }
            }
            if (this.triggerLifeCycle != null) {
                try {
                    this.triggerLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping trigger service", (Throwable)e);
                }
            }
            if (this.indexUpdateLifeCycle != null) {
                try {
                    this.indexUpdateLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping index update service", (Throwable)e);
                }
            }
        }
    }

    public static interface Dependencies {
        public GraphDatabaseAPI graphdatabaseAPI();

        public JobScheduler scheduler();

        public Procedures procedures();

        public LogService log();
    }
}

