/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.Pools;
import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.algorithms.AlgorithmInterface;
import apoc.algo.algorithms.BetweennessCentrality;
import apoc.result.NodeScore;
import apoc.util.Util;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.ClosenessCentrality;
import org.neo4j.graphalgo.impl.centrality.CostDivider;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Centrality {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public GraphDatabaseAPI dbAPI;
    @Context
    public TerminationGuard guard;
    static final ExecutorService pool = Pools.DEFAULT;

    @Procedure(value="apoc.algo.betweenness")
    @Description(value="CALL apoc.algo.betweenness(['TYPE',...],nodes,BOTH) YIELD node, score - calculate betweenness centrality for given nodes")
    public Stream<NodeScore> betweenness(@Name(value="types") List<String> types, @Name(value="nodes") List<Node> nodes, @Name(value="direction") String direction) {
        this.assertParametersNotNull(types, nodes);
        try {
            RelationshipType[] relationshipTypes = types.isEmpty() ? Util.allRelationshipTypes(this.db) : Util.toRelTypes(types);
            SingleSourceShortestPathDijkstra sssp = new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, dir) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Util.parseDirection(direction), relationshipTypes);
            org.neo4j.graphalgo.impl.centrality.BetweennessCentrality betweennessCentrality = new org.neo4j.graphalgo.impl.centrality.BetweennessCentrality((SingleSourceShortestPath)sssp, new HashSet<Node>(nodes));
            return nodes.stream().map(node -> new NodeScore((Node)node, (Double)betweennessCentrality.getCentrality(node)));
        }
        catch (Exception e) {
            String errMsg = "Error encountered while calculating centrality";
            this.log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    @Procedure(value="apoc.algo.betweennessCypher", mode=Mode.WRITE)
    @Description(value="CALL apoc.algo.betweennessCypher(node_cypher,rel_cypher,write) - calculates betweeness  centrality based on cypher input")
    public Stream<AlgorithmInterface.Statistics> betweennessCypher(@Name(value="config") Map<String, Object> config) {
        String nodeCypher = AlgoUtils.getCypher(config, "node_cypher", "MATCH (s) RETURN id(s) as id");
        String relCypher = AlgoUtils.getCypher(config, "rel_cypher", "MATCH (s)-[r]->(t) RETURN id(s) as source, id(t) as target, 1 as weight");
        boolean shouldWrite = (Boolean)config.getOrDefault("write", false);
        Number weight = (Number)config.get("weight");
        Number batchSize = (Number)config.get("batchSize");
        int concurrency = ((Number)config.getOrDefault("concurrency", Pools.getNoThreadsInDefaultPool())).intValue();
        String property = (String)config.getOrDefault("property", "betweenness_centrality");
        long beforeReading = System.currentTimeMillis();
        this.log.info("BetweennessCypher: Reading data into local ds");
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(this.dbAPI, pool, this.log, this.guard);
        boolean success = betweennessCentrality.readNodeAndRelCypherData(relCypher, nodeCypher, weight, batchSize, concurrency);
        if (!success) {
            String errorMsg = "Failure while reading cypher queries. Make sure the results are ordered.";
            this.log.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        long afterReading = System.currentTimeMillis();
        this.log.info("BetweennessCypher: Graph stored in local ds in " + (afterReading - beforeReading) + " milliseconds");
        this.log.info("BetweennessCypher: Number of nodes: " + betweennessCentrality.numberOfNodes());
        this.log.info("BetweennessCypher: Number of relationships: " + betweennessCentrality.numberOfRels());
        betweennessCentrality.computeUnweightedParallel();
        long afterComputation = System.currentTimeMillis();
        this.log.info("BetweennessCypher: Computations took " + (afterComputation - afterReading) + " milliseconds");
        if (shouldWrite) {
            betweennessCentrality.writeResultsToDB(property);
            long afterWrite = System.currentTimeMillis();
            this.log.info("BetweennessCypher: Writeback took " + (afterWrite - afterComputation) + " milliseconds");
        }
        return Stream.of(betweennessCentrality.getStatistics());
    }

    @Procedure(value="apoc.algo.closeness")
    @Description(value="CALL apoc.algo.closeness(['TYPE',...],nodes, INCOMING) YIELD node, score - calculate closeness centrality for given nodes")
    public Stream<NodeScore> closeness(@Name(value="types") List<String> types, @Name(value="nodes") List<Node> nodes, @Name(value="direction") String direction) {
        this.assertParametersNotNull(types, nodes);
        try {
            RelationshipType[] relationshipTypes = types.isEmpty() ? Util.allRelationshipTypes(this.db) : Util.toRelTypes(types);
            SingleSourceShortestPathDijkstra sssp = new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, dir) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Util.parseDirection(direction), relationshipTypes);
            ClosenessCentrality closenessCentrality = new ClosenessCentrality((SingleSourceShortestPath)sssp, (CostAccumulator)new DoubleAdder(), (Object)0.0, new HashSet<Node>(nodes), (CostDivider)new CostDivider<Double>(){

                public Double divideByCost(Double d, Double c) {
                    return d / c;
                }

                public Double divideCost(Double c, Double d) {
                    return c / d;
                }
            });
            return nodes.stream().map(node -> new NodeScore((Node)node, (Double)closenessCentrality.getCentrality(node)));
        }
        catch (Exception e) {
            String errMsg = "Error encountered while calculating centrality";
            this.log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    private void assertParametersNotNull(List<String> types, List<Node> nodes) {
        if (null == types || null == nodes) {
            String errMsg = "Neither 'types' nor 'nodes' procedure parameters may not be null.";
            if (null == types) {
                errMsg = errMsg + " 'types' is null";
            }
            if (null == nodes) {
                errMsg = errMsg + " 'nodes' is null";
            }
            this.log.error(errMsg);
            throw new RuntimeException(errMsg);
        }
    }
}

