/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Cliques {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.algo.cliques(minSize) YIELD cliques - search the graph and return all maximal cliques at least at large as the minimum size argument.")
    public Stream<CliqueResult> cliques(@Name(value="minSize") Number size) {
        HashMap<Long, Node> nodesToSearchFrom = new HashMap<Long, Node>();
        for (Node node : this.db.getAllNodes()) {
            nodesToSearchFrom.put(node.getId(), node);
        }
        return this.find_clique(new HashMap<Long, Node>(), nodesToSearchFrom, new HashMap<Long, Node>()).stream().filter(cliqueResult -> cliqueResult.clique.size() >= size.intValue());
    }

    @Procedure
    @Description(value="apoc.algo.cliquesWithNode(startNode, minSize) YIELD cliques - search the graph and return all maximal cliques that are at least as large than the minimum size argument and contain this node ")
    public Stream<CliqueResult> cliquesWithNode(@Name(value="startNode") Node startNode, @Name(value="minSize") Number size) {
        HashMap<Long, Node> nodesToSearchFrom = new HashMap<Long, Node>();
        nodesToSearchFrom.put(startNode.getId(), startNode);
        for (Relationship relationship : startNode.getRelationships()) {
            Node otherNode = relationship.getOtherNode(startNode);
            nodesToSearchFrom.put(otherNode.getId(), otherNode);
        }
        return this.find_clique(new HashMap<Long, Node>(), nodesToSearchFrom, new HashMap<Long, Node>()).stream().filter(cliqueResult -> cliqueResult.clique.size() >= size.intValue());
    }

    private List<CliqueResult> find_clique(Map<Long, Node> potentialClique, Map<Long, Node> remainingNodes, Map<Long, Node> skipNodes) {
        LinkedList<CliqueResult> cliques = new LinkedList<CliqueResult>();
        if (remainingNodes.size() == 0 && skipNodes.size() == 0 && potentialClique.size() > 0) {
            cliques.add(new CliqueResult(potentialClique));
            return cliques;
        }
        Iterator<Map.Entry<Long, Node>> it = remainingNodes.entrySet().iterator();
        while (it.hasNext()) {
            Node node = it.next().getValue();
            HashMap<Long, Node> newPotentialClique = new HashMap<Long, Node>(potentialClique);
            newPotentialClique.put(node.getId(), node);
            HashMap<Long, Node> newRemainingNodes = new HashMap<Long, Node>();
            HashMap<Long, Node> newSkipNodes = new HashMap<Long, Node>();
            for (Relationship relationship : node.getRelationships()) {
                Node sibling = relationship.getOtherNode(node);
                if (remainingNodes.get(sibling.getId()) != null) {
                    newRemainingNodes.put(sibling.getId(), sibling);
                }
                if (skipNodes.get(sibling.getId()) == null) continue;
                newSkipNodes.put(sibling.getId(), sibling);
            }
            cliques.addAll(this.find_clique(newPotentialClique, newRemainingNodes, newSkipNodes));
            it.remove();
            skipNodes.put(node.getId(), node);
        }
        return cliques;
    }

    public static class CliqueResult {
        public List<Node> clique;

        public CliqueResult(Map<Long, Node> nodes) {
            this.clique = nodes.values().stream().collect(Collectors.toList());
        }
    }
}

