/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class CoreGraphAlgorithms {
    private final Statement stmt;
    private int nodeCount;
    private int relCount;
    private int[] nodeRelOffsets;
    private int[] rels;
    public static final float ALPHA = 0.15f;
    private int labelId;
    private int relTypeId;

    private long spreadBits32(int y) {
        long x = y;
        x = (x | x << 32) & 0xFFFFFFFFL;
        x = (x | x << 16) & 0xFFFF0000FFFFL;
        x = (x | x << 8) & 0xFF00FF00FF00FFL;
        x = (x | x << 4) & 0xF0F0F0F0F0F0F0FL;
        x = (x | x << 2) & 0x3333333333333333L;
        x = (x | x << 1) & 0x5555555555555555L;
        return x;
    }

    private long interleave64(int x, int y) {
        return this.spreadBits32(x) | this.spreadBits32(y) << 1;
    }

    private int encode(int x, int y, int r) {
        int mask = (1 << r) - 1;
        int hodd = 0;
        int heven = x ^ y;
        int notx = ~x & mask;
        int noty = ~y & mask;
        int temp = notx ^ y;
        int v0 = 0;
        int v1 = 0;
        for (int k = 1; k < r; ++k) {
            v1 = (v1 & heven | (v0 ^ noty) & temp) >> 1;
            v0 = (v0 & (v1 ^ notx) | ~v0 & (v1 ^ noty)) >> 1;
        }
        hodd = ~v0 & (v1 ^ x) | v0 & (v1 ^ noty);
        return CoreGraphAlgorithms.interleaveBits(hodd, heven);
    }

    private static int interleaveBits(int odd, int even) {
        int val = 0;
        int n = 0;
        for (int max = Math.max(odd, even); max > 0; max >>= 1) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            int bitMask = 1 << i;
            int a = (even & bitMask) > 0 ? 1 << 2 * i : 0;
            int b = (odd & bitMask) > 0 ? 1 << 2 * i + 1 : 0;
            val += a + b;
        }
        return val;
    }

    int xy2d(int n, int x, int y) {
        int[] xy = new int[2];
        int d = 0;
        for (int s = n >> 1; s != 0; s >>= 1) {
            int rx = (x & s) != 0 ? 1 : 0;
            int ry = (y & s) != 0 ? 1 : 0;
            d += s * s * (3 * rx ^ ry);
            xy[0] = x;
            xy[1] = y;
            this.rot(s, xy, rx, ry);
        }
        return d;
    }

    void d2xy(int n, int d, int[] xy) {
        int t = d;
        xy[0] = 0;
        xy[1] = 0;
        for (int s = 1; s != n; s <<= 1) {
            int rx = 1 & t >> 1;
            int ry = 1 & (t ^ rx);
            this.rot(s, xy, rx, ry);
            xy[0] = xy[0] + s * rx;
            xy[1] = xy[1] + s * ry;
            t /= 4;
        }
    }

    void rot(int n, int[] xy, int rx, int ry) {
        if (ry == 0) {
            if (rx == 1) {
                xy[0] = n - 1 - xy[0];
                xy[1] = n - 1 - xy[1];
            }
            int t = xy[0];
            xy[0] = xy[1];
            xy[1] = t;
        }
    }

    public static int toInt(double value) {
        return (int)(100000.0 * value);
    }

    public static double toFloat(int value) {
        return (double)value / 100000.0;
    }

    private int[] loadNodes(ReadOperations ops, PrimitiveLongIterator nodeIds, int size, int relType, Direction direction) throws EntityNotFoundException {
        int[] offsets = new int[size];
        int offset = 0;
        while (nodeIds.hasNext()) {
            long nodeId = nodeIds.next();
            int degree = relType == -1 ? ops.nodeGetDegree(nodeId, direction) : ops.nodeGetDegree(nodeId, direction, relType);
            offsets[CoreGraphAlgorithms.mapId((long)nodeId)] = offset;
            offset += degree;
        }
        return offsets;
    }

    private int[] loadDegrees(ReadOperations ops, PrimitiveLongIterator nodeIds, int size, int relType, Direction direction) throws EntityNotFoundException {
        int[] degrees = new int[size];
        while (nodeIds.hasNext()) {
            long nodeId = nodeIds.next();
            degrees[CoreGraphAlgorithms.mapId((long)nodeId)] = relType == -1 ? ops.nodeGetDegree(nodeId, direction) : ops.nodeGetDegree(nodeId, direction, relType);
        }
        return degrees;
    }

    public int[] loadDegrees(String relName, Direction direction) throws EntityNotFoundException {
        ReadOperations ops = this.stmt.readOperations();
        int[] degrees = new int[this.nodeCount];
        if (relName == null) {
            for (int nodeIdx = 0; nodeIdx < this.nodeCount; ++nodeIdx) {
                degrees[nodeIdx] = ops.nodeGetDegree(CoreGraphAlgorithms.unMapId(nodeIdx), direction);
            }
        } else {
            int relType = ops.relationshipTypeGetForName(relName);
            for (int nodeIdx = 0; nodeIdx < this.nodeCount; ++nodeIdx) {
                degrees[nodeIdx] = ops.nodeGetDegree(CoreGraphAlgorithms.unMapId(nodeIdx), direction, relType);
            }
        }
        return degrees;
    }

    private int[] loadDegrees(ReadOperations ops, int relType, Direction direction) {
        try {
            int[] degrees = new int[this.nodeCount];
            for (int nodeIdx = 0; nodeIdx < this.nodeCount; ++nodeIdx) {
                degrees[nodeIdx] = relType == -1 ? ops.nodeGetDegree(CoreGraphAlgorithms.unMapId(nodeIdx), direction) : ops.nodeGetDegree(CoreGraphAlgorithms.unMapId(nodeIdx), direction, relType);
            }
            return degrees;
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException("Error loading node degrees", e);
        }
    }

    private int[] loadNodes(ReadOperations ops, PrimitiveLongIterator nodeIds, int labelId, int size, int relType) throws EntityNotFoundException {
        int[] degrees = new int[size];
        while (nodeIds.hasNext()) {
            Cursor c;
            long nodeId = nodeIds.next();
            if (labelId != -1 && (!(c = ops.nodeCursorById(nodeId)).next() || !((NodeItem)c.get()).hasLabel(labelId))) continue;
            degrees[CoreGraphAlgorithms.mapId((long)nodeId)] = relType == -1 ? ops.nodeGetDegree(nodeId, Direction.OUTGOING) : ops.nodeGetDegree(nodeId, Direction.OUTGOING, relType);
        }
        return degrees;
    }

    private int loadNodeRels(ReadOperations ops, PrimitiveLongIterator nodeIds, int relType, int[] rels) throws EntityNotFoundException {
        int idx = 0;
        int count = 0;
        while (nodeIds.hasNext()) {
            RelationshipIterator relIds;
            long id = nodeIds.next();
            int[] relTypes = new int[]{relType};
            RelationshipIterator relationshipIterator = relIds = relType == -1 ? ops.nodeGetRelationships(id, Direction.OUTGOING) : ops.nodeGetRelationships(id, Direction.OUTGOING, relTypes);
            while (relIds.hasNext()) {
                Cursor c = ops.relationshipCursorById(relIds.next());
                rels[idx] = CoreGraphAlgorithms.mapId(((RelationshipItem)c.get()).endNode());
                ++count;
                ++idx;
            }
        }
        return count;
    }

    private void runProgram(RelationshipProgram consumer) {
        CoreGraphAlgorithms.runProgram(this.nodeCount, this.nodeRelOffsets, this.rels, consumer);
    }

    private static void runProgram(int nodeCount, int[] offsets, int[] rels, RelationshipProgram consumer) {
        for (int start = 0; start < nodeCount; ++start) {
            int end;
            int nextOffset;
            int n = nextOffset = start + 1 == nodeCount ? rels.length : offsets[start + 1];
            for (int offset = offsets[start]; offset != nextOffset && (end = rels[offset]) != -1; ++offset) {
                consumer.accept(start, end);
            }
        }
    }

    public float[] pageRank(int iterations) {
        float oneMinusAlpha = 0.85f;
        int[] degrees = this.loadDegrees(this.stmt.readOperations(), this.relTypeId, Direction.OUTGOING);
        float[] dst = new float[this.nodeCount];
        float[] src = new float[this.nodeCount];
        for (int it = 0; it < iterations; ++it) {
            for (int node = 0; node < this.nodeCount; ++node) {
                src[node] = 0.15f * dst[node] / (float)degrees[node];
                dst[node] = oneMinusAlpha;
            }
            this.runProgram((start, end) -> {
                int n = end;
                dst[n] = dst[n] + src[start];
            });
        }
        for (int node = 0; node < this.nodeCount; ++node) {
            if (degrees[node] != 0 || dst[node] != oneMinusAlpha) continue;
            dst[node] = 0.0f;
        }
        return dst;
    }

    public void pregel(RelationshipProgram program, SuperStep superStep) {
        while (superStep.run()) {
            this.runProgram(program);
        }
    }

    public float[] pageRank2(int iterations) {
        class PageRank
        implements SuperStep,
        RelationshipProgram {
            private int iterations;
            float alpha = 0.15f;
            float oneMinusAlpha = 1.0f - this.alpha;
            float[] dst = new float[CoreGraphAlgorithms.access$000(CoreGraphAlgorithms.this)];
            float[] src = new float[CoreGraphAlgorithms.access$000(CoreGraphAlgorithms.this)];

            public PageRank(int iterations) {
                this.iterations = iterations;
            }

            @Override
            public void accept(int start, int end) {
                int n = end;
                this.dst[n] = this.dst[n] + this.src[start];
            }

            @Override
            public boolean run() {
                for (int node = 0; node < CoreGraphAlgorithms.this.nodeCount; ++node) {
                    this.src[node] = this.alpha * this.dst[node] / (float)CoreGraphAlgorithms.this.nodeRelOffsets[node];
                    this.dst[node] = this.oneMinusAlpha;
                }
                return this.iterations-- > 0;
            }
        }
        PageRank program = new PageRank(iterations);
        this.pregel(program, program);
        return program.dst;
    }

    public int[] labelPropagation() {
        int[] labels = new int[this.nodeCount];
        for (int nodeId = 0; nodeId < this.nodeCount; ++nodeId) {
            labels[nodeId] = nodeId;
        }
        boolean[] done = new boolean[]{false};
        while (!done[0]) {
            done[0] = true;
            this.runProgram((start, end) -> {
                if (labels[start] != labels[end]) {
                    done[0] = false;
                    labels[start] = labels[end] = Math.min(labels[start], labels[end]);
                }
            });
        }
        return labels;
    }

    public int[] unionFind() {
        byte[] rank = new byte[this.nodeCount];
        int[] root = new int[this.nodeCount];
        for (int nodeId = 0; nodeId < this.nodeCount; ++nodeId) {
            root[nodeId] = nodeId;
        }
        this.runProgram((x, y) -> {
            while (x != root[x]) {
                x = root[x];
            }
            while (y != root[y]) {
                y = root[y];
            }
            if (x != y) {
                if (rank[x] >= rank[y]) {
                    root[y] = x;
                    if (rank[x] == rank[y]) {
                        int n = x;
                        rank[n] = (byte)(rank[n] + 1);
                    }
                } else {
                    root[x] = y;
                }
            }
        });
        return root;
    }

    private int loadRels(ReadOperations ops, PrimitiveLongIterator relIds, int size, int relType, int[] rels) throws EntityNotFoundException {
        int idx = 0;
        int count = 0;
        while (relIds.hasNext()) {
            long relId = relIds.next();
            Cursor c = ops.relationshipCursorById(relId);
            if (c.next() && (relType == -1 || ((RelationshipItem)c.get()).type() == relType)) {
                rels[idx] = CoreGraphAlgorithms.mapId(((RelationshipItem)c.get()).endNode());
                ++count;
            }
            ++idx;
        }
        return count;
    }

    private static int mapId(long id) {
        return (int)id;
    }

    private static long unMapId(int id) {
        return id;
    }

    public CoreGraphAlgorithms(Statement stmt) {
        this.stmt = stmt;
    }

    private void loadRels(ReadOperations ops, int labelId, int relTypeId) throws EntityNotFoundException {
        int allRelCount = (int)ops.relationshipsGetCount();
        this.relCount = (int)ops.countsForRelationshipWithoutTxState(labelId, relTypeId, -1);
        this.rels = new int[this.relCount];
        float percentage = (float)this.relCount / (float)allRelCount;
        PrimitiveLongIterator nodeIds = labelId == -1 ? ops.nodesGetAll() : ops.nodesGetForLabel(labelId);
        this.relCount = this.loadNodeRels(ops, nodeIds, relTypeId, this.rels);
    }

    private void loadNodes(ReadOperations ops, int labelId, int relTypeId) throws EntityNotFoundException {
        this.labelId = labelId;
        this.relTypeId = relTypeId;
        int allNodeCount = (int)ops.nodesGetCount();
        if (labelId == -1) {
            this.nodeCount = allNodeCount;
            this.nodeRelOffsets = this.loadNodes(ops, ops.nodesGetAll(), this.nodeCount, relTypeId, Direction.OUTGOING);
        } else {
            this.nodeCount = (int)ops.countsForNodeWithoutTxState(labelId);
            float percentage = (float)this.nodeCount / (float)allNodeCount;
            this.nodeRelOffsets = percentage > 0.5f ? this.loadNodes(ops, ops.nodesGetAll(), labelId, this.nodeCount, relTypeId) : this.loadNodes(ops, ops.nodesGetForLabel(labelId), this.nodeCount, relTypeId, Direction.OUTGOING);
        }
    }

    public CoreGraphAlgorithms init(String label) throws EntityNotFoundException {
        ReadOperations ops = this.stmt.readOperations();
        int labelId = ops.labelGetForName(label);
        this.loadNodes(ops, labelId, -1);
        this.loadRels(ops, labelId, -1);
        return this;
    }

    public CoreGraphAlgorithms init(String label, String rel) throws EntityNotFoundException {
        ReadOperations ops = this.stmt.readOperations();
        int labelId = ops.labelGetForName(label);
        int relTypeId = ops.relationshipTypeGetForName(rel);
        this.loadNodes(ops, labelId, relTypeId);
        this.loadRels(ops, labelId, relTypeId);
        return this;
    }

    public CoreGraphAlgorithms init() throws EntityNotFoundException {
        ReadOperations ops = this.stmt.readOperations();
        this.loadNodes(ops, -1, -1);
        this.loadRels(ops, -1, -1);
        return this;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getRelCount() {
        return this.relCount;
    }

    public int[] getNodeRelOffsets() {
        return this.nodeRelOffsets;
    }

    public int[] getRels() {
        return this.rels;
    }

    static interface SuperStep {
        public boolean run();
    }

    static interface RelationshipProgram {
        public void accept(int var1, int var2);
    }
}

