/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Cover {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.algo.cover(nodes) yield rel - returns all relationships between this set of nodes")
    public Stream<RelationshipResult> cover(@Name(value="nodes") Object nodes) {
        Set nodeSet = Util.nodeStream(this.db, nodes).collect(Collectors.toSet());
        return nodeSet.parallelStream().flatMap(n -> Util.inTx(this.db, () -> StreamSupport.stream(n.getRelationships(Direction.OUTGOING).spliterator(), false).filter(r -> nodeSet.contains(r.getEndNode())).map(RelationshipResult::new)));
    }

    public static Stream<Relationship> coverNodes(Collection<Node> nodes) {
        return nodes.stream().flatMap(n -> StreamSupport.stream(n.getRelationships(Direction.OUTGOING).spliterator(), false).filter(r -> nodes.contains(r.getEndNode())));
    }
}

