/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.Pools;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class LabelPropagation {
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard guard;
    @Context
    public Log log;

    @Procedure(name="apoc.algo.community", mode=Mode.WRITE)
    @Description(value="CALL apoc.algo.community(times,labels,partitionKey,type,direction,weightKey,batchSize) - simple label propagation kernel")
    public void community(@Name(value="times") long times, @Name(value="labels") List<String> labelNames, @Name(value="partitionKey") String partitionKey, @Name(value="type") String relationshipTypeName, @Name(value="direction") String directionName, @Name(value="weightKey") String weightKey, @Name(value="batchSize") long batchSize) throws ExecutionException {
        HashSet labels;
        HashSet hashSet = labels = labelNames == null ? Collections.emptySet() : new HashSet(labelNames.size());
        if (labelNames != null) {
            labelNames.forEach(name -> labels.add(Label.label((String)name)));
        }
        RelationshipType relationshipType = relationshipTypeName == null ? null : RelationshipType.withName((String)relationshipTypeName);
        Direction direction = Util.parseDirection(directionName);
        int i = 0;
        while ((long)i < times) {
            ArrayList<Node> batch = null;
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            Throwable throwable = null;
            try (Transaction tx = this.db.beginTx();){
                if (Util.transactionIsTerminated(this.guard)) {
                    return;
                }
                for (Node node : this.db.getAllNodes()) {
                    boolean add;
                    boolean bl = add = labels.size() == 0;
                    if (!add) {
                        Iterator nodeLabels = node.getLabels().iterator();
                        while (!add && nodeLabels.hasNext()) {
                            if (!labels.contains(nodeLabels.next())) continue;
                            add = true;
                        }
                    }
                    if (!add) continue;
                    if (batch == null) {
                        batch = new ArrayList<Node>((int)batchSize);
                    }
                    batch.add(node);
                    if ((long)batch.size() != batchSize) continue;
                    futures.add(this.clusterBatch(batch, partitionKey, relationshipType, direction, weightKey));
                    batch = null;
                }
                if (batch != null) {
                    futures.add(this.clusterBatch(batch, partitionKey, relationshipType, direction, weightKey));
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Future future : futures) {
                Pools.force(future);
            }
            ++i;
        }
    }

    private Future<Void> clusterBatch(List<Node> batch, String partitionKey, RelationshipType relationshipType, Direction direction, String weightKey) {
        return Pools.processBatch(batch, this.db, node -> {
            Object originalPartition;
            HashMap<Object, Double> votes = new HashMap<Object, Double>();
            for (Relationship rel : relationshipType == null ? node.getRelationships(direction) : node.getRelationships(relationshipType, direction)) {
                Node other = rel.getOtherNode(node);
                Object partition = this.partition(other, partitionKey);
                double weight = this.weight((PropertyContainer)rel, weightKey) * this.weight((PropertyContainer)other, weightKey);
                this.vote(votes, partition, weight);
            }
            Object partition = originalPartition = this.partition((Node)node, partitionKey);
            double weight = 0.0;
            for (Map.Entry entry : votes.entrySet()) {
                if (!(weight < (Double)entry.getValue())) continue;
                weight = (Double)entry.getValue();
                partition = entry.getKey();
            }
            if (partition != originalPartition) {
                node.setProperty(partitionKey, partition);
            }
        });
    }

    private void vote(Map<Object, Double> votes, Object partition, double weight) {
        double currentWeight = votes.getOrDefault(partition, 0.0);
        double newWeight = currentWeight + weight;
        votes.put(partition, newWeight);
    }

    private double weight(PropertyContainer container, String propertyKey) {
        Object propertyValue;
        if (propertyKey != null && (propertyValue = container.getProperty(propertyKey, null)) instanceof Number) {
            return ((Number)propertyValue).doubleValue();
        }
        return 1.0;
    }

    private Object partition(Node node, String partitionKey) {
        Object partition = node.getProperty(partitionKey, null);
        return partition == null ? Long.valueOf(node.getId()) : partition;
    }
}

