/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.path.RelationshipTypeAndDirections;
import apoc.result.PathResult;
import apoc.result.WeightedPathResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PathFinding {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.algo.aStar(startNode, endNode, 'KNOWS|<WORKS_WITH|IS_MANAGER_OF>', 'distance','lat','lon') YIELD path, weight - run A* with relationship property name as cost function")
    public Stream<WeightedPathResult> aStar(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="weightPropertyName") String weightPropertyName, @Name(value="latPropertyName") String latPropertyName, @Name(value="lonPropertyName") String lonPropertyName) {
        PathFinder algo = GraphAlgoFactory.aStar(this.buildPathExpander(relTypesAndDirs), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)weightPropertyName), (EstimateEvaluator)CommonEvaluators.geoEstimateEvaluator((String)latPropertyName, (String)lonPropertyName));
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @Procedure
    @Description(value="apoc.algo.aStar(startNode, endNode, 'KNOWS|<WORKS_WITH|IS_MANAGER_OF>', {weight:'dist',default:10,x:'lon',y:'lat'}) YIELD path, weight - run A* with relationship property name as cost function")
    public Stream<WeightedPathResult> aStarConfig(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="config") Map<String, Object> config) {
        config = config == null ? Collections.emptyMap() : config;
        String relationshipCostPropertyKey = config.getOrDefault("weight", "distance").toString();
        double defaultCost = ((Number)config.getOrDefault("default", Double.MAX_VALUE)).doubleValue();
        String latPropertyName = config.getOrDefault("y", "latitude").toString();
        String lonPropertyName = config.getOrDefault("x", "longitude").toString();
        PathFinder algo = GraphAlgoFactory.aStar(this.buildPathExpander(relTypesAndDirs), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)relationshipCostPropertyKey, (double)defaultCost), (EstimateEvaluator)CommonEvaluators.geoEstimateEvaluator((String)latPropertyName, (String)lonPropertyName));
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @Procedure
    @Description(value="apoc.algo.dijkstra(startNode, endNode, 'KNOWS|<WORKS_WITH|IS_MANAGER_OF>', 'distance') YIELD path, weight - run dijkstra with relationship property name as cost function")
    public Stream<WeightedPathResult> dijkstra(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="weightPropertyName") String weightPropertyName) {
        PathFinder algo = GraphAlgoFactory.dijkstra(this.buildPathExpander(relTypesAndDirs), (String)weightPropertyName);
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @Procedure
    @Description(value="apoc.algo.allSimplePaths(startNode, endNode, 'KNOWS|<WORKS_WITH|IS_MANAGER_OF>', 5) YIELD path, weight - run allSimplePaths with relationships given and maxNodes")
    public Stream<PathResult> allSimplePaths(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="maxNodes") long maxNodes) {
        PathFinder algo = GraphAlgoFactory.allSimplePaths(this.buildPathExpander(relTypesAndDirs), (int)((int)maxNodes));
        Iterable allPaths = algo.findAllPaths(startNode, endNode);
        return StreamSupport.stream(allPaths.spliterator(), false).map(PathResult::new);
    }

    @Procedure
    @Description(value="apoc.algo.dijkstraWithDefaultWeight(startNode, endNode, 'KNOWS|<WORKS_WITH|IS_MANAGER_OF>', 'distance', 10) YIELD path, weight - run dijkstra with relationship property name as cost function and a default weight if the property does not exist")
    public Stream<WeightedPathResult> dijkstraWithDefaultWeight(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="weightPropertyName") String weightPropertyName, @Name(value="defaultWeight") double defaultWeight) {
        PathFinder algo = GraphAlgoFactory.dijkstra(this.buildPathExpander(relTypesAndDirs), (relationship, direction) -> Util.toDouble(relationship.getProperty(weightPropertyName, (Object)defaultWeight)));
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    private PathExpander<Object> buildPathExpander(String relationshipsAndDirections) {
        PathExpanderBuilder builder = PathExpanderBuilder.empty();
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(relationshipsAndDirections)) {
            if (pair.first() == null) {
                if (pair.other() == null) {
                    builder = PathExpanderBuilder.allTypesAndDirections();
                    continue;
                }
                builder = PathExpanderBuilder.allTypes((Direction)((Direction)pair.other()));
                continue;
            }
            if (pair.other() == null) {
                builder = builder.add((RelationshipType)pair.first());
                continue;
            }
            builder = builder.add((RelationshipType)pair.first(), (Direction)pair.other());
        }
        return builder.build();
    }
}

