/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.Pools;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class Pregel {
    GraphDatabaseAPI api;
    private ThreadToStatementContextBridge ctx;
    private int batchSize = 10000;
    private ExecutorService pool = Pools.DEFAULT;
    private final TerminationGuard guard;

    public Pregel(GraphDatabaseAPI api, TerminationGuard guard) {
        this.api = api;
        this.ctx = (ThreadToStatementContextBridge)api.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.guard = guard;
    }

    public Pregel withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Pregel withPool(ExecutorService pool) {
        this.pool = pool;
        return this;
    }

    public <STATE, RESULT> RESULT runProgram(PrimitiveLongIterator nodes, NodeExpander expander, PregelProgram<STATE, RESULT> program) throws Exception {
        RESULT result;
        List<long[]> batches = this.batchLongIterator(nodes);
        ArrayList<Object> states = new ArrayList<Object>(1024);
        do {
            states.clear();
            for (long[] batch : batches) {
                states.add(this.runBatch(expander, program, batch));
            }
            this.resolveFutures(states);
        } while ((result = program.next(states)) == null);
        return result;
    }

    public <STATE, RESULT> RESULT runProgram2(PrimitiveLongIterator nodes, NodeExpander expander, PregelProgram<STATE, RESULT> program) throws Exception {
        RESULT result;
        List<long[]> relBatches = this.collectRelationshipBatches(nodes, expander);
        ArrayList<Object> states = new ArrayList<Object>(1024);
        do {
            states.clear();
            for (long[] relBatch : relBatches) {
                states.add(this.runRelBatch(program, relBatch));
            }
            this.resolveFutures(states);
        } while ((result = program.next(states)) == null);
        return result;
    }

    public <STATE, RESULT> RESULT runProgram3(PrimitiveLongIterator nodes, NodeExpander expander, PregelProgram<STATE, RESULT> program) throws Exception {
        RESULT result;
        List<long[]> relBatches = this.collectRelationshipBatches(nodes, expander);
        IdentityHashMap<PregelProgram<STATE, RESULT>, long[]> programs = new IdentityHashMap<PregelProgram<STATE, RESULT>, long[]>(relBatches.size());
        for (long[] relBatch : relBatches) {
            programs.put(program.newInstance(), relBatch);
        }
        ArrayList<Object> states = new ArrayList<Object>(1024);
        do {
            states.clear();
            for (Map.Entry entry : programs.entrySet()) {
                states.add(this.runRelBatch((PregelProgram)entry.getKey(), (long[])entry.getValue()));
            }
            this.resolveFutures(states);
        } while ((result = program.next(states)) == null);
        return result;
    }

    private void resolveFutures(List<Object> states) throws InterruptedException, ExecutionException {
        int numStates = states.size();
        for (int i = 0; i < numStates; ++i) {
            states.set(i, ((Future)states.get(i)).get());
        }
    }

    private List<long[]> collectRelationshipBatches(PrimitiveLongIterator nodes, NodeExpander expander) throws InterruptedException, ExecutionException {
        ArrayList<Future<long[]>> states = new ArrayList<Future<long[]>>(1024);
        while (nodes.hasNext()) {
            long[] batch = new long[this.batchSize];
            this.grabBatch(nodes, batch);
            Future<long[]> future = this.pool.submit(() -> {
                try (Transaction tx = this.api.beginTx();){
                    if (Util.transactionIsTerminated(this.guard)) {
                        long[] lArray = new long[]{};
                        return lArray;
                    }
                    Statement statement = this.statement();
                    CollectingRelationshipVisitor visitor = new CollectingRelationshipVisitor();
                    for (long node : batch) {
                        if (node == -1L) break;
                        expander.expand(node, statement, visitor);
                    }
                    tx.success();
                    long[] lArray = visitor.getRelBatch();
                    return lArray;
                }
            });
            states.add(future);
        }
        ArrayList<long[]> relBatches = new ArrayList<long[]>(states.size());
        for (Future future : states) {
            relBatches.add((long[])future.get());
        }
        return relBatches;
    }

    private <R> R get(Future<R> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<long[]> batchLongIterator(PrimitiveLongIterator nodes) {
        ArrayList<long[]> batches = new ArrayList<long[]>(1024);
        while (nodes.hasNext()) {
            long[] batch = new long[this.batchSize];
            int len = this.grabBatch(nodes, batch);
            batches.add(batch);
        }
        return batches;
    }

    private int grabBatch(PrimitiveLongIterator nodes, long[] batch) {
        try (Transaction tx = this.api.beginTx();){
            if (Util.transactionIsTerminated(this.guard)) {
                int n = 0;
                return n;
            }
            int idx = 0;
            while (nodes.hasNext() && idx < this.batchSize) {
                batch[idx++] = nodes.next();
            }
            if (idx < this.batchSize) {
                batch[idx] = -1L;
            }
            tx.success();
            int n = idx;
            return n;
        }
    }

    private <STATE, RESULT> Future<STATE> runRelBatch(PregelProgram<STATE, RESULT> program, long[] relBatch) {
        return this.pool.submit(() -> {
            try (Transaction tx = this.api.beginTx();){
                if (Util.transactionIsTerminated(this.guard)) {
                    Object STATE = program.state();
                    return STATE;
                }
                Statement statement = this.ctx.get();
                Object state = program.state();
                int len = relBatch.length;
                for (int idx = 0; idx < len; idx += 4) {
                    program.accept(relBatch[idx], relBatch[idx + 1], relBatch[idx + 2], (int)relBatch[idx + 3], statement, state);
                }
                tx.success();
                Object STATE = state;
                return STATE;
            }
        });
    }

    private <STATE, RESULT> Future<STATE> runBatch(NodeExpander expander, PregelProgram<STATE, RESULT> program, long[] batch) {
        return this.pool.submit(() -> {
            try (Transaction tx = this.api.beginTx();){
                if (Util.transactionIsTerminated(this.guard)) {
                    Object STATE = program.state();
                    return STATE;
                }
                Statement statement = this.ctx.get();
                Object state = program.state();
                for (long node : batch) {
                    if (node == -1L) break;
                    expander.expand(node, statement, (RelationshipVisitor<RuntimeException>)((RelationshipVisitor)(id, type, start, end) -> program.accept(id, start, end, type, statement, state)));
                }
                tx.success();
                Object STATE = state;
                return STATE;
            }
        });
    }

    public Statement statement() {
        return this.ctx.get();
    }

    private class CollectingRelationshipVisitor
    implements RelationshipVisitor<RuntimeException> {
        int idx = 0;
        long[] relBatch = new long[Pregel.access$000(Pregel.this) * 10];

        private CollectingRelationshipVisitor() {
        }

        public void visit(long id, int type, long start, long end) throws RuntimeException {
            if (this.idx + 4 > this.relBatch.length) {
                this.relBatch = Arrays.copyOf(this.relBatch, this.relBatch.length + Pregel.this.batchSize * 10);
            }
            this.relBatch[this.idx] = id;
            this.relBatch[this.idx + 1] = start;
            this.relBatch[this.idx + 2] = end;
            this.relBatch[this.idx + 3] = type;
            this.idx += 4;
        }

        public long[] getRelBatch() {
            return Arrays.copyOf(this.relBatch, this.idx);
        }
    }

    public static class AllExpander
    implements NodeExpander {
        @Override
        public boolean expand(long node, Statement stmt, RelationshipVisitor<RuntimeException> callback) {
            ReadOperations reads = stmt.readOperations();
            RelationshipIterator rels = this.relationships(node, reads);
            while (rels.hasNext()) {
                rels.relationshipVisit(rels.next(), callback);
            }
            return false;
        }

        private RelationshipIterator relationships(long node, ReadOperations reads) {
            try {
                return reads.nodeGetRelationships(node, Direction.BOTH);
            }
            catch (EntityNotFoundException e) {
                throw new RuntimeException("error expanding node " + node, e);
            }
        }
    }

    public static interface PregelProgram<STATE, RESULT> {
        public boolean accept(long var1, long var3, long var5, int var7, Statement var8, STATE var9);

        public RESULT next(List<STATE> var1);

        public STATE state();

        public PregelProgram<STATE, RESULT> newInstance();
    }

    public static interface NodeExpander {
        public boolean expand(long var1, Statement var3, RelationshipVisitor<RuntimeException> var4);
    }
}

