/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.algorithms;

import apoc.algo.algorithms.AlgorithmInterface;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class AlgoUtils {
    public static final String SETTING_CYPHER_NODE = "node_cypher";
    public static final String SETTING_CYPHER_REL = "rel_cypher";
    public static final String SETTING_WRITE = "write";
    public static final String SETTING_WEIGHTED = "weight";
    public static final String SETTING_BATCH_SIZE = "batchSize";
    public static final String DEFAULT_CYPHER_REL = "MATCH (s)-[r]->(t) RETURN id(s) as source, id(t) as target, 1 as weight";
    public static final String DEFAULT_CYPHER_NODE = "MATCH (s) RETURN id(s) as id";
    public static final boolean DEFAULT_PAGE_RANK_WRITE = false;

    public static String getCypher(Map<String, Object> config, String setting, String defaultString) {
        String cypher = (String)config.getOrDefault(setting, defaultString);
        if ("none".equals(cypher)) {
            return null;
        }
        if (cypher == null || cypher.isEmpty()) {
            return defaultString;
        }
        return cypher;
    }

    public static int waitForTasks(List<Future> futures) {
        int total = 0;
        for (Future future : futures) {
            try {
                future.get();
                ++total;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        futures.clear();
        return total;
    }

    public static void writeBackResults(ExecutorService pool, final GraphDatabaseAPI db, final AlgorithmInterface algorithm, final int batchSize, final TerminationGuard guard) {
        int propertyNameId;
        final ThreadToStatementContextBridge ctx = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        try (Transaction tx = db.beginTx();){
            if (Util.transactionIsTerminated(guard)) {
                return;
            }
            propertyNameId = ctx.get().tokenWriteOperations().propertyKeyGetOrCreateForName(algorithm.getPropertyName());
            tx.success();
        }
        catch (IllegalTokenNameException e) {
            throw new RuntimeException(e);
        }
        final long totalNodes = algorithm.numberOfNodes();
        int batches = (int)totalNodes / batchSize;
        ArrayList<Future> futures = new ArrayList<Future>(batches);
        int i = 0;
        while ((long)i < totalNodes) {
            int nodeIndex;
            final int start = nodeIndex = i;
            Future<?> future = pool.submit(new Runnable(){

                @Override
                public void run() {
                    try (Transaction tx = db.beginTx();){
                        int nodeIndex;
                        if (Util.transactionIsTerminated(guard)) {
                            return;
                        }
                        DataWriteOperations ops = ctx.get().dataWriteOperations();
                        for (int i = 0; i < batchSize && (long)(nodeIndex = i + start) < totalNodes; ++i) {
                            long graphNode = algorithm.getMappedNode(nodeIndex);
                            double value = algorithm.getResult(graphNode);
                            if (graphNode == -1L) {
                                System.out.println("Node node found for " + graphNode + " mapped node " + nodeIndex);
                                continue;
                            }
                            ops.nodeSetProperty(graphNode, DefinedProperty.doubleProperty((int)propertyNameId, (double)value));
                        }
                        tx.success();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            futures.add(future);
            i += batchSize;
        }
        AlgoUtils.waitForTasks(futures);
    }
}

