/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.pagerank;

import apoc.algo.pagerank.OpsRunner;
import apoc.algo.pagerank.PageRankUtils;
import apoc.util.Util;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class BatchRunnable
implements Runnable,
OpsRunner {
    final long[] ids;
    private final OpsRunner runner;
    private final GraphDatabaseAPI api;
    int offset = 0;
    private final TerminationGuard guard;

    public BatchRunnable(GraphDatabaseAPI api, PrimitiveLongIterator iterator, int batchSize, OpsRunner runner, TerminationGuard guard) {
        this.api = api;
        this.guard = guard;
        this.ids = this.add(iterator, batchSize);
        this.runner = runner;
    }

    private long[] add(PrimitiveLongIterator it, int count) {
        long[] ids = new long[count];
        Arrays.fill(ids, -1L);
        while (count-- > 0 && it.hasNext()) {
            ids[this.offset++] = it.next();
        }
        return ids;
    }

    @Override
    public void run() {
        try (Transaction tx = this.api.beginTx();){
            if (Util.transactionIsTerminated(this.guard)) {
                return;
            }
            ReadOperations ops = PageRankUtils.ctx(this.api).get().readOperations();
            int notFound = 0;
            for (int i = 0; i < this.offset && this.ids[i] != -1L; ++i) {
                try {
                    this.run(ops, (int)this.ids[i]);
                    continue;
                }
                catch (EntityNotFoundException e) {
                    ++notFound;
                }
            }
            if (notFound > 0) {
                System.err.println("Entities not found " + notFound);
            }
            tx.success();
        }
    }

    @Override
    public void run(ReadOperations ops, int node) throws EntityNotFoundException {
        this.runner.run(ops, node);
    }
}

