/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.pagerank;

import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.algorithms.AlgorithmInterface;
import apoc.algo.pagerank.BatchRunnable;
import apoc.algo.pagerank.PageRank;
import apoc.algo.pagerank.PageRankUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class PageRankArrayStorageParallelSPI
implements PageRank,
AlgorithmInterface {
    public static final int ONE_MINUS_ALPHA_INT = PageRankUtils.toInt(0.15000000000000002);
    private final GraphDatabaseAPI db;
    private final TerminationGuard guard;
    private final int nodeCount;
    private final ExecutorService pool;
    private final int relCount;
    private AtomicIntegerArray dst;
    private PageRank.PageRankStatistics stats = new PageRank.PageRankStatistics();

    public PageRankArrayStorageParallelSPI(GraphDatabaseService db, TerminationGuard guard, ExecutorService pool) {
        this.guard = guard;
        this.pool = pool;
        this.db = (GraphDatabaseAPI)db;
        this.nodeCount = this.getNodeCount(this.db);
        this.relCount = this.getRelationshipCount(this.db);
    }

    @Override
    public void compute(int iterations, RelationshipType ... relationshipTypes) {
        this.stats.iterations = iterations;
        long start = System.currentTimeMillis();
        int[] src = new int[this.nodeCount];
        this.dst = new AtomicIntegerArray(this.nodeCount);
        int[] degrees = this.computeDegrees(PageRankUtils.ctx(this.db));
        this.stats.readNodeMillis = System.currentTimeMillis() - start;
        this.stats.nodes = this.nodeCount;
        start = System.currentTimeMillis();
        ReadOperations ops = PageRankUtils.ctx(this.db).get().readOperations();
        IntPredicate isValidRelationshipType = this.relationshipTypeArrayToIntPredicate(ops, relationshipTypes);
        RelationshipVisitor visitor = isValidRelationshipType == null ? (relId, relTypeId, startNode, endNode) -> this.dst.addAndGet((int)endNode, src[(int)startNode]) : (relId, relTypeId, startNode, endNode) -> {
            if (isValidRelationshipType.test(relTypeId)) {
                this.dst.addAndGet((int)endNode, src[(int)startNode]);
            }
        };
        PrimitiveLongIterator rels = ops.relationshipsGetAll();
        List<BatchRunnable> runners = PageRankUtils.prepareOperations(rels, this.relCount, this.db, (readOps, id) -> readOps.relationshipVisit((long)id, visitor), this.guard);
        this.stats.readRelationshipMillis = System.currentTimeMillis() - start;
        this.stats.relationships = this.relCount;
        start = System.currentTimeMillis();
        for (int iteration = 0; iteration < iterations; ++iteration) {
            this.startIteration(src, this.dst, degrees);
            PageRankUtils.runOperations(this.pool, runners);
        }
        this.stats.computeMillis = System.currentTimeMillis() - start;
    }

    private IntPredicate relationshipTypeArrayToIntPredicate(ReadOperations ops, RelationshipType ... relationshipTypes) {
        if (0 == relationshipTypes.length) {
            return null;
        }
        BitSet relationshipTypeSet = new BitSet(relationshipTypes.length);
        for (RelationshipType relationshipType : relationshipTypes) {
            int relTypeId = ops.relationshipTypeGetForName(relationshipType.name());
            if (relTypeId < 0) continue;
            relationshipTypeSet.set(relTypeId);
        }
        return relationshipTypeSet::get;
    }

    private void startIteration(int[] src, AtomicIntegerArray dst, int[] degrees) {
        for (int node = 0; node < this.nodeCount; ++node) {
            if (degrees[node] == -1) continue;
            src[node] = PageRankUtils.toInt(0.85 * PageRankUtils.toFloat(dst.getAndSet(node, ONE_MINUS_ALPHA_INT)) / (double)degrees[node]);
        }
    }

    private int[] computeDegrees(ThreadToStatementContextBridge ctx) {
        int[] degree = new int[this.nodeCount];
        Arrays.fill(degree, -1);
        PrimitiveLongIterator it = ctx.get().readOperations().nodesGetAll();
        int totalCount = this.nodeCount;
        PageRankUtils.runOperations(this.pool, it, totalCount, this.db, (ops, id) -> {
            degree[id] = ops.nodeGetDegree((long)id, Direction.OUTGOING);
        }, this.guard);
        return degree;
    }

    @Override
    public double getResult(long node) {
        return this.dst != null ? PageRankUtils.toFloat(this.dst.get((int)node)) : 0.0;
    }

    @Override
    public long numberOfNodes() {
        return this.nodeCount;
    }

    @Override
    public String getPropertyName() {
        return "pagerank";
    }

    @Override
    public PageRank.PageRankStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public long getMappedNode(int algoId) {
        return algoId;
    }

    public void writeResultsToDB() {
        this.stats.write = true;
        long before = System.currentTimeMillis();
        AlgoUtils.writeBackResults(this.pool, this.db, this, 100100, this.guard);
        this.stats.write = true;
        this.stats.writeMillis = System.currentTimeMillis() - before;
        this.stats.property = this.getPropertyName();
    }

    private int getNodeCount(GraphDatabaseAPI db) {
        return (int)this.getNeoStores(db).getNodeStore().getHighestPossibleIdInUse() + 1;
    }

    private NeoStores getNeoStores(GraphDatabaseAPI db) {
        RecordStorageEngine recordStorageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        StoreAccess storeAccess = new StoreAccess(recordStorageEngine.testAccessNeoStores());
        return storeAccess.getRawNeoStores();
    }

    private int getRelationshipCount(GraphDatabaseAPI db) {
        return (int)this.getNeoStores(db).getRelationshipStore().getHighestPossibleIdInUse() + 1;
    }
}

