/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.pagerank;

import apoc.algo.pagerank.BatchRunnable;
import apoc.algo.pagerank.OpsRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class PageRankUtils {
    static final int BATCH_SIZE = 100000;

    public static int toInt(double value) {
        return (int)(100000.0 * value);
    }

    public static double toFloat(int value) {
        return (double)value / 100000.0;
    }

    public static int waitForTasks(List<Future> futures) {
        int total = 0;
        for (Future future : futures) {
            try {
                future.get();
                ++total;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        futures.clear();
        return total;
    }

    public static void runOperations(ExecutorService pool, PrimitiveLongIterator it, int totalCount, GraphDatabaseAPI api, OpsRunner runner, TerminationGuard guard) {
        ArrayList<Future> futures = new ArrayList<Future>(totalCount / 100000 + 1);
        while (it.hasNext()) {
            futures.add(pool.submit(new BatchRunnable(api, it, 100000, runner, guard)));
        }
        PageRankUtils.waitForTasks(futures);
    }

    public static void runOperations(ExecutorService pool, List<BatchRunnable> runners) {
        ArrayList<Future> futures = new ArrayList<Future>(runners.size());
        for (BatchRunnable runnable : runners) {
            futures.add(pool.submit(runnable));
        }
        PageRankUtils.waitForTasks(futures);
    }

    public static List<BatchRunnable> prepareOperations(PrimitiveLongIterator it, int totalCount, GraphDatabaseAPI api, OpsRunner runner, TerminationGuard guard) {
        ArrayList<BatchRunnable> runners = new ArrayList<BatchRunnable>(totalCount / 100000 + 1);
        while (it.hasNext()) {
            runners.add(new BatchRunnable(api, it, 100000, runner, guard));
        }
        return runners;
    }

    public static ThreadToStatementContextBridge ctx(GraphDatabaseAPI db) {
        return (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

