/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.coll.SetBackedList;
import apoc.meta.Meta;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Convert {
    @Context
    public Log log;

    @UserFunction
    @Description(value="apoc.convert.toMap(value) | tries it's best to convert the value to a map")
    public Map<String, Object> toMap(@Name(value="map") Object map) {
        if (map instanceof PropertyContainer) {
            return ((PropertyContainer)map).getAllProperties();
        }
        if (map instanceof Map) {
            return (Map)map;
        }
        return null;
    }

    @UserFunction
    @Description(value="apoc.convert.toString(value) | tries it's best to convert the value to a string")
    public String toString(@Name(value="string") Object string) {
        return string == null ? null : string.toString();
    }

    @UserFunction
    @Description(value="apoc.convert.toList(value) | tries it's best to convert the value to a list")
    public List<Object> toList(@Name(value="list") Object list) {
        return this.convertToList(list);
    }

    @UserFunction
    @Description(value="apoc.convert.toBoolean(value) | tries it's best to convert the value to a boolean")
    public Boolean toBoolean(@Name(value="bool") Object bool) {
        return Util.toBoolean(bool);
    }

    @UserFunction
    @Description(value="apoc.convert.toNode(value) | tries it's best to convert the value to a node")
    public Node toNode(@Name(value="node") Object node) {
        return node instanceof Node ? (Node)node : null;
    }

    @UserFunction
    @Description(value="apoc.convert.toRelationship(value) | tries it's best to convert the value to a relationship")
    public Relationship toRelationship(@Name(value="relationship") Object relationship) {
        return relationship instanceof Relationship ? (Relationship)relationship : null;
    }

    private List convertToList(Object list) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            return (List)list;
        }
        if (list instanceof Collection) {
            return new ArrayList((Collection)list);
        }
        if (list instanceof Iterable) {
            return (List)Iterables.addToCollection((Iterable)((Iterable)list), new ArrayList(100));
        }
        if (list instanceof Iterator) {
            return (List)Iterators.addToCollection((Iterator)((Iterator)list), new ArrayList(100));
        }
        if (list.getClass().isArray() && !list.getClass().getComponentType().isPrimitive()) {
            ArrayList result = new ArrayList(100);
            Collections.addAll(result, (Object[])list);
            return result;
        }
        return null;
    }

    private <T> List<T> convertToList(Object list, Class<T> type) {
        List convertedList = this.convertToList(list);
        if (convertedList == null) {
            return null;
        }
        Stream<Object> stream = null;
        Meta.Types varType = Meta.Types.of(type);
        switch (varType) {
            case INTEGER: {
                stream = convertedList.stream().map(Util::toLong);
                break;
            }
            case FLOAT: {
                stream = convertedList.stream().map(Util::toDouble);
                break;
            }
            case STRING: {
                stream = convertedList.stream().map(this::toString);
                break;
            }
            case BOOLEAN: {
                stream = convertedList.stream().map(this::toBoolean);
                break;
            }
            case NODE: {
                stream = convertedList.stream().map(this::toNode);
                break;
            }
            case RELATIONSHIP: {
                stream = convertedList.stream().map(this::toRelationship);
                break;
            }
            default: {
                throw new RuntimeException("Supported types are: Integer, Float, String, Boolean, Node, Relationship");
            }
        }
        return stream.collect(Collectors.toList());
    }

    @UserFunction
    @Description(value="apoc.convert.toSet(value) | tries it's best to convert the value to a set")
    public List<Object> toSet(@Name(value="list") Object value) {
        List list = this.convertToList(value);
        return list == null ? null : new SetBackedList(new LinkedHashSet(list));
    }

    @UserFunction
    @Description(value="apoc.convert.toIntList(value) | tries it's best to convert the value to a list of integers")
    public List<Long> toIntList(@Name(value="list") Object list) {
        return this.convertToList(list, Long.class);
    }

    @UserFunction
    @Description(value="apoc.convert.toStringList(value) | tries it's best to convert the value to a list of strings")
    public List<String> toStringList(@Name(value="list") Object list) {
        return this.convertToList(list, String.class);
    }

    @UserFunction
    @Description(value="apoc.convert.toBooleanList(value) | tries it's best to convert the value to a list of booleans")
    public List<Boolean> toBooleanList(@Name(value="list") Object list) {
        return this.convertToList(list, Boolean.class);
    }

    @UserFunction
    @Description(value="apoc.convert.toNodeList(value) | tries it's best to convert the value to a list of nodes")
    public List<Node> toNodeList(@Name(value="list") Object list) {
        return this.convertToList(list, Node.class);
    }

    @UserFunction
    @Description(value="apoc.convert.toRelationshipList(value) | tries it's best to convert the value to a list of relationships")
    public List<Relationship> toRelationshipList(@Name(value="list") Object list) {
        return this.convertToList(list, Relationship.class);
    }

    @UserFunction
    @Description(value="apoc.convert.toInteger(value) | tries it's best to convert the value to an integer")
    public Long toInteger(@Name(value="object") Object obj) {
        if (obj == null || obj.equals("")) {
            return null;
        }
        Meta.Types varType = Meta.Types.of(obj);
        switch (varType) {
            case INTEGER: 
            case FLOAT: {
                return ((Number)obj).longValue();
            }
            case STRING: {
                return this.parseLongString((String)obj);
            }
            case BOOLEAN: {
                return (Boolean)obj != false ? 1L : 0L;
            }
        }
        return null;
    }

    private Long parseLongString(String input) {
        if (input.equalsIgnoreCase("true")) {
            return 1L;
        }
        if (input.equalsIgnoreCase("false")) {
            return 0L;
        }
        if (input.startsWith("0x")) {
            return Long.valueOf(input.substring(2), 16);
        }
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException nfe) {
            try {
                return (long)Double.parseDouble(input);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    @UserFunction
    @Description(value="apoc.convert.toFloat(value) | tries it's best to convert the value to a float")
    public Double toFloat(@Name(value="object") Object obj) {
        if (obj == null || obj.equals("")) {
            return null;
        }
        Meta.Types varType = Meta.Types.of(obj);
        switch (varType) {
            case INTEGER: 
            case FLOAT: {
                return ((Number)obj).doubleValue();
            }
            case STRING: {
                return this.parseDoubleString((String)obj);
            }
            case BOOLEAN: {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
        }
        return null;
    }

    private Double parseDoubleString(String input) {
        if (input.equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (input.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            if (input.startsWith("0x")) {
                return Long.parseLong(input.substring(2), 16);
            }
            return Double.parseDouble(input);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

