/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.couchbase.CouchbaseConnection;
import apoc.couchbase.CouchbaseManager;
import apoc.couchbase.document.CouchbaseJsonDocument;
import apoc.couchbase.document.CouchbaseQueryResult;
import apoc.couchbase.document.CouchbaseUtils;
import apoc.result.BooleanResult;
import apoc.util.MissingDependencyException;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Couchbase {
    @Procedure
    @Description(value="apoc.couchbase.get(nodes, bucket, documentId) yield id, expiry, cas, mutationToken, content - retrieves a couchbase json document by its unique ID.")
    public Stream<CouchbaseJsonDocument> get(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.get(documentId);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.exists(nodes, bucket, documentId) yield value - check whether a couchbase json document with the given ID does exist.")
    public Stream<BooleanResult> exists(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        Stream<BooleanResult> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            result = Stream.of(new BooleanResult(couchbaseConnection.exists(documentId)));
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.insert(nodes, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - insert a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> insert(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.insert(documentId, json);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.upsert(nodes, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - insert or overwrite a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> upsert(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.upsert(documentId, json);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.append(nodes, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - append a couchbase json document to an existing one.")
    public Stream<CouchbaseJsonDocument> append(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.append(documentId, json);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.prepend(nodes, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - prepend a couchbase json document to an existing one.")
    public Stream<CouchbaseJsonDocument> prepend(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.prepend(documentId, json);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.remove(nodes, bucket, documentId) yield id, expiry, cas, mutationToken, content - remove the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> remove(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.remove(documentId);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.replace(nodes, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - replace the content of the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> replace(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Stream<CouchbaseJsonDocument> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.replace(documentId, json);
            if (jsonDocument != null) {
                result = Stream.of(new CouchbaseJsonDocument(jsonDocument));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.query(nodes, bucket, statement) yield queryResult - executes a plain un-parameterized N1QL statement.")
    public Stream<CouchbaseQueryResult> query(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="statement") String statement) {
        Stream<CouchbaseQueryResult> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeStatement(statement);
            if (statementResult != null) {
                result = Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.posParamsQuery(nodes, bucket, statement, params) yield queryResult - executes a N1QL statement with positional parameters.")
    public Stream<CouchbaseQueryResult> posParamsQuery(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="params") List<Object> params) {
        Stream<CouchbaseQueryResult> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeParametrizedStatement(statement, params);
            if (statementResult != null) {
                result = Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            }
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.couchbase.namedParamsQuery(nodes, bucket, statement, paramNames, paramValues) yield queryResult - executes a N1QL statement with named parameters.")
    public Stream<CouchbaseQueryResult> namedParamsQuery(@Name(value="nodes") List<String> nodes, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="paramNames") List<String> paramNames, @Name(value="paramValues") List<Object> paramValues) {
        Stream<CouchbaseQueryResult> result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(nodes, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeParametrizedStatement(statement, paramNames, paramValues);
            if (statementResult != null) {
                result = Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CouchbaseConnection getCouchbaseConnection(List<String> nodes, String bucket) {
        try (CouchbaseConnection couchbaseConnection = CouchbaseManager.getConnection(nodes, bucket);){
            CouchbaseConnection couchbaseConnection2 = couchbaseConnection;
            return couchbaseConnection2;
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException("Cannot find the jar into the plugins folder. \nPlease put these jar in the plugins folder : \n\njava-client-x.y.z.jar\n\ncore-io-x.y.z.jar\n\nrxjava-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_interacting_with_couchbase");
        }
    }
}

