/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.result.MapResult;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Timeboxed {
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction tx;
    @Context
    public Log log;

    @Procedure
    @Description(value="apoc.cypher.runTimeboxed('cypherStatement',{params}, timeout) - abort statement after timeout ms if not finished")
    public Stream<MapResult> runTimeboxed(@Name(value="cypher") String cypher, @Name(value="params") Map<String, Object> params, @Name(value="timeout") long timeout) {
        Pools.SCHEDULED.schedule(() -> {
            String txString = this.tx == null ? "<null>" : this.tx.toString();
            this.log.warn("marking " + txString + " for termination");
            this.tx.markForTermination((Status)Status.Transaction.Terminated);
        }, timeout, TimeUnit.MILLISECONDS);
        Result result = this.db.execute(cypher, params == null ? Collections.EMPTY_MAP : params);
        return result.stream().map(MapResult::new);
    }
}

