/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.Description;
import apoc.export.csv.CsvFormat;
import apoc.export.util.ExportConfig;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ExportCSV {
    @Context
    public GraphDatabaseService db;

    public ExportCSV(GraphDatabaseService db) {
        this.db = db;
    }

    public ExportCSV() {
    }

    @Procedure
    @Description(value="apoc.export.csv.all(file,config) - exports whole database as csv to the provided file")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.db), Util.relCount(this.db));
        return this.exportCsv(fileName, source, new DatabaseSubGraph(this.db), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.data(nodes,rels,file,config) - exports given nodes and relationships as csv to the provided file")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.db, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.graph(graph,file,config) - exports given graph object as csv to the provided file")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.db, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.query(query,file,{config,...,params:{params}}) - exports results from the cypher statement as csv to the provided file")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.db.execute(query, params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportCsv(fileName, source, result, config);
    }

    private Stream<ProgressInfo> exportCsv(@Name(value="file") String fileName, String source, Object data, Map<String, Object> config) throws Exception {
        FileUtils.checkWriteAllowed();
        ExportConfig c = new ExportConfig(config);
        ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(fileName, source, "csv"));
        PrintWriter printWriter = FileUtils.getPrintWriter(fileName, null);
        CsvFormat exporter = new CsvFormat(this.db);
        if (data instanceof SubGraph) {
            exporter.dump((SubGraph)data, (Writer)printWriter, (Reporter)reporter, c);
        }
        if (data instanceof Result) {
            exporter.dump((Result)data, (Writer)printWriter, (Reporter)reporter, c);
        }
        return reporter.stream();
    }
}

