/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.util.FileUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FileManagerFactory {
    public static ExportCypherFileManager createFileManager(String fileName, boolean separatedFiles, boolean b) {
        return fileName == null ? new StringExportCypherFileManager(fileName, separatedFiles) : new PhysicalExportCypherFileManager(fileName, separatedFiles);
    }

    private static class StringExportCypherFileManager
    implements ExportCypherFileManager {
        private final String fileName;
        private boolean separatedFiles;
        private ConcurrentMap<String, StringWriter> writers = new ConcurrentHashMap<String, StringWriter>();

        public StringExportCypherFileManager(String fileName, boolean separatedFiles) {
            this.fileName = fileName;
            this.separatedFiles = separatedFiles;
        }

        @Override
        public PrintWriter getPrintWriter(String type) throws IOException {
            if (this.separatedFiles) {
                return new PrintWriter(this.writers.compute(type, (key, writer) -> writer == null ? new StringWriter() : writer));
            }
            return new PrintWriter(this.writers.compute("cypher", (key, writer) -> writer == null ? new StringWriter() : writer));
        }

        @Override
        public synchronized String drain(String type) {
            StringWriter writer = (StringWriter)this.writers.get(type);
            if (writer != null) {
                String text = writer.toString();
                writer.getBuffer().setLength(0);
                return text;
            }
            return null;
        }
    }

    private static class PhysicalExportCypherFileManager
    implements ExportCypherFileManager {
        private final String fileName;
        private boolean separatedFiles;
        private PrintWriter writer;

        public PhysicalExportCypherFileManager(String fileName, boolean separatedFiles) {
            this.fileName = fileName;
            this.separatedFiles = separatedFiles;
        }

        @Override
        public PrintWriter getPrintWriter(String type) throws IOException {
            if (this.separatedFiles) {
                return FileUtils.getPrintWriter(this.normalizeFileName(this.fileName, type), null);
            }
            if (this.writer == null) {
                this.writer = FileUtils.getPrintWriter(this.normalizeFileName(this.fileName, null), null);
            }
            return this.writer;
        }

        private String normalizeFileName(String fileName, String suffix) {
            return fileName.replace(".cypher", suffix != null ? "." + suffix + ".cypher" : ".cypher");
        }

        @Override
        public String drain(String type) {
            return null;
        }
    }

    static interface ExportCypherFileManager {
        public PrintWriter getPrintWriter(String var1) throws IOException;

        public String drain(String var1);
    }
}

