/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.FileManagerFactory;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.Reporter;
import apoc.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class MultiStatementCypherSubGraphExporter {
    private final SubGraph graph;
    private final Map<String, String> uniqueConstraints = new HashMap<String, String>();
    private Set<String> indexNames = new LinkedHashSet<String>();
    private Set<String> indexedProperties = new LinkedHashSet<String>();
    private Long artificialUniques = 0L;
    private ExportFormat exportFormat;
    private CypherFormatter cypherFormat;

    public MultiStatementCypherSubGraphExporter(SubGraph graph, ExportConfig config) {
        this.graph = graph;
        this.exportFormat = config.getFormat();
        this.cypherFormat = config.getCypherFormat().getFormatter();
        this.gatherUniqueConstraints();
    }

    public void export(ExportConfig config, Reporter reporter, FileManagerFactory.ExportCypherFileManager cypherFileManager) throws IOException {
        int batchSize = config.getBatchSize();
        this.exportNodes(cypherFileManager.getPrintWriter("nodes"), reporter, batchSize);
        this.exportSchema(cypherFileManager.getPrintWriter("schema"));
        this.exportRelationships(cypherFileManager.getPrintWriter("relationships"), reporter, batchSize);
        this.exportCleanUp(cypherFileManager.getPrintWriter("cleanup"), batchSize);
        reporter.done();
    }

    public void exportOnlySchema(FileManagerFactory.ExportCypherFileManager cypherFileManager) throws IOException {
        this.exportSchema(cypherFileManager.getPrintWriter("schema"));
    }

    private void exportNodes(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getNodes().iterator().hasNext()) {
            this.begin(out);
            this.appendNodes(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private long appendNodes(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Node node : this.graph.getNodes()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendNode(out, node, reporter);
        }
        return count;
    }

    private void appendNode(PrintWriter out, Node node, Reporter reporter) {
        this.artificialUniques = this.artificialUniques + this.countArtificialUniques(node);
        String cypher = this.cypherFormat.statementForNode(node, this.uniqueConstraints, this.indexedProperties, this.indexNames);
        if (Util.isNotNullOrEmpty(cypher)) {
            out.println(cypher);
            reporter.update(1L, 0L, Iterables.count((Iterable)node.getPropertyKeys()));
        }
    }

    private void exportRelationships(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getRelationships().iterator().hasNext()) {
            this.begin(out);
            this.appendRelationships(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private long appendRelationships(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Relationship rel : this.graph.getRelationships()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendRelationship(out, rel, reporter);
        }
        return count;
    }

    private void appendRelationship(PrintWriter out, Relationship rel, Reporter reporter) {
        String cypher = this.cypherFormat.statementForRelationship(rel, this.uniqueConstraints, this.indexedProperties);
        if (cypher != null && !"".equals(cypher)) {
            out.println(cypher);
            reporter.update(0L, 1L, Iterables.count((Iterable)rel.getPropertyKeys()));
        }
    }

    private void exportSchema(PrintWriter out) {
        String cypher;
        List<String> indexes = this.exportIndexes();
        if (indexes.isEmpty() && this.artificialUniques == 0L) {
            return;
        }
        this.begin(out);
        for (String index : indexes) {
            out.println(index);
        }
        if (this.artificialUniques > 0L && (cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", "UNIQUE IMPORT ID")) != null && !"".equals(cypher)) {
            out.println(cypher);
        }
        this.commit(out);
        List<String> indexesAwait = this.indexesAwait();
        for (String indexAwait : indexesAwait) {
            out.print(indexAwait);
        }
        this.schemaAwait(out);
        out.flush();
    }

    private List<String> exportIndexes() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexDefinition index : this.graph.getIndexes()) {
            String cypher;
            String label = index.getLabel().name();
            Iterable props = index.getPropertyKeys();
            if (index.isConstraintIndex()) {
                cypher = this.cypherFormat.statementForConstraint(label, (String)Iterables.single((Iterable)props));
                if (cypher == null || "".equals(cypher)) continue;
                result.add(cypher);
                continue;
            }
            cypher = this.cypherFormat.statementForIndex(label, props);
            if (cypher == null || "".equals(cypher)) continue;
            result.add(0, cypher);
        }
        return result;
    }

    private List<String> indexesAwait() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexDefinition index : this.graph.getIndexes()) {
            String label = index.getLabel().name();
            String indexAwait = this.exportFormat.indexAwait(label, index.getPropertyKeys());
            if (indexAwait == null || "".equals(indexAwait)) continue;
            result.add(indexAwait);
        }
        return result;
    }

    private void exportCleanUp(PrintWriter out, int batchSize) {
        if (this.artificialUniques > 0L) {
            String cypher;
            while (this.artificialUniques > 0L) {
                cypher = this.cypherFormat.statementForCleanUp(batchSize);
                this.begin(out);
                if (cypher != null && !"".equals(cypher)) {
                    out.println(cypher);
                }
                this.commit(out);
                this.artificialUniques = this.artificialUniques - (long)batchSize;
            }
            this.begin(out);
            cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", "UNIQUE IMPORT ID").replaceAll("^CREATE", "DROP");
            if (cypher != null && !"".equals(cypher)) {
                out.println(cypher);
            }
            this.commit(out);
        }
        out.flush();
    }

    private void begin(PrintWriter out) {
        out.print(this.exportFormat.begin());
    }

    private void schemaAwait(PrintWriter out) {
        out.print(this.exportFormat.schemaAwait());
    }

    private void restart(PrintWriter out) {
        this.commit(out);
        this.begin(out);
    }

    private void commit(PrintWriter out) {
        out.print(this.exportFormat.commit());
    }

    private void gatherUniqueConstraints() {
        for (IndexDefinition indexDefinition : this.graph.getIndexes()) {
            String label = indexDefinition.getLabel().name();
            String prop = (String)Iterables.first((Iterable)indexDefinition.getPropertyKeys());
            this.indexNames.add(label);
            this.indexedProperties.add(prop);
            if (!indexDefinition.isConstraintIndex() || this.uniqueConstraints.containsKey(label)) continue;
            this.uniqueConstraints.put(label, prop);
        }
    }

    private long countArtificialUniques(Node node) {
        long artificialUniques = 0L;
        Iterator labels = node.getLabels().iterator();
        boolean uniqueFound = false;
        while (labels.hasNext()) {
            Label next = (Label)labels.next();
            String labelName = next.name();
            if (!this.uniqueConstraints.containsKey(labelName) || !node.hasProperty(this.uniqueConstraints.get(labelName))) continue;
            uniqueFound = true;
        }
        if (!uniqueFound) {
            ++artificialUniques;
        }
        return artificialUniques;
    }
}

