/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.Reporter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class XmlGraphMLWriter {
    public void write(SubGraph graph, Writer writer, Reporter reporter, ExportConfig config) throws Exception {
        int props;
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
        this.writeHeader(xmlWriter);
        if (config.useTypes()) {
            this.writeKeyTypes(xmlWriter, graph);
        }
        this.writeGraph(xmlWriter);
        for (Node node : graph.getNodes()) {
            props = this.writeNode(xmlWriter, node);
            reporter.update(1L, 0L, props);
        }
        for (Relationship rel : graph.getRelationships()) {
            props = this.writeRelationship(xmlWriter, rel);
            reporter.update(0L, 1L, props);
        }
        this.writeFooter(xmlWriter);
    }

    private void writeKeyTypes(XMLStreamWriter writer, SubGraph ops) throws Exception {
        HashMap<String, Class> keyTypes = new HashMap<String, Class>();
        for (Node node : ops.getNodes()) {
            MetaInformation.updateKeyTypes(keyTypes, (PropertyContainer)node);
        }
        this.writeKeyTypes(writer, keyTypes, "node");
        keyTypes.clear();
        for (Relationship rel : ops.getRelationships()) {
            MetaInformation.updateKeyTypes(keyTypes, (PropertyContainer)rel);
        }
        this.writeKeyTypes(writer, keyTypes, "edge");
    }

    private void writeKeyTypes(XMLStreamWriter writer, Map<String, Class> keyTypes, String forType) throws IOException, XMLStreamException {
        for (Map.Entry<String, Class> entry : keyTypes.entrySet()) {
            Class typeClass = entry.getValue();
            String type = MetaInformation.typeFor(typeClass, MetaInformation.GRAPHML_ALLOWED);
            if (type == null) continue;
            writer.writeEmptyElement("key");
            writer.writeAttribute("id", entry.getKey());
            writer.writeAttribute("for", forType);
            writer.writeAttribute("attr.name", entry.getKey());
            if (typeClass.isArray()) {
                writer.writeAttribute("attr.type", "string");
                writer.writeAttribute("attr.list", type);
            } else {
                writer.writeAttribute("attr.type", type);
            }
            this.newLine(writer);
        }
    }

    private int writeNode(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        writer.writeStartElement("node");
        writer.writeAttribute("id", this.id(node));
        this.writeLabels(writer, node);
        this.writeLabelsAsData(writer, node);
        int props = this.writeProps(writer, (PropertyContainer)node);
        this.endElement(writer);
        return props;
    }

    private String id(Node node) {
        return "n" + node.getId();
    }

    private void writeLabels(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (!labelsString.isEmpty()) {
            writer.writeAttribute("labels", labelsString);
        }
    }

    private void writeLabelsAsData(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (labelsString.isEmpty()) {
            return;
        }
        this.writeData(writer, "labels", labelsString);
    }

    private int writeRelationship(XMLStreamWriter writer, Relationship rel) throws IOException, XMLStreamException {
        writer.writeStartElement("edge");
        writer.writeAttribute("id", this.id(rel));
        writer.writeAttribute("source", this.id(rel.getStartNode()));
        writer.writeAttribute("target", this.id(rel.getEndNode()));
        writer.writeAttribute("label", rel.getType().name());
        this.writeData(writer, "label", rel.getType().name());
        int props = this.writeProps(writer, (PropertyContainer)rel);
        this.endElement(writer);
        return props;
    }

    private String id(Relationship rel) {
        return "e" + rel.getId();
    }

    private void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        this.newLine(writer);
    }

    private int writeProps(XMLStreamWriter writer, PropertyContainer node) throws IOException, XMLStreamException {
        int count = 0;
        for (String prop : node.getPropertyKeys()) {
            Object value = node.getProperty(prop);
            this.writeData(writer, prop, value);
            ++count;
        }
        return count;
    }

    private void writeData(XMLStreamWriter writer, String prop, Object value) throws IOException, XMLStreamException {
        writer.writeStartElement("data");
        writer.writeAttribute("key", prop);
        if (value != null) {
            writer.writeCharacters(FormatUtils.toString(value));
        }
        writer.writeEndElement();
    }

    private void writeFooter(XMLStreamWriter writer) throws IOException, XMLStreamException {
        this.endElement(writer);
        this.endElement(writer);
        writer.writeEndDocument();
    }

    private void writeHeader(XMLStreamWriter writer) throws IOException, XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.newLine(writer);
        writer.writeStartElement("graphml");
        writer.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
        writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi", "", "schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        this.newLine(writer);
    }

    private void writeGraph(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G");
        writer.writeAttribute("edgedefault", "directed");
        this.newLine(writer);
    }

    private void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(System.getProperty("line.separator"));
    }
}

